package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGWilburwine {

	/**
	 * Demonstrates loading and querying of the Wilburwine dataset.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("wilburwine", AGPaths.TRIPLE_STORES);

		// Load the wilburwine dataset
		AGLoadNtriples.loadNTriplesWithTiming(ts,AGPaths.dataSources("wilburwine.ntriples"));
		
		// Index the triple store for faster querying
		AGIndexAllTriples.indexAllTriplesWithTiming(ts);

		// Register a wine namespace
		ts.registerNamespace("wine", "http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine#");
		
		// Get triples having subject CabernetSauvignonGrape and show them
		System.out.println("Triples with Subject: CabernetSauvignonGrape");
		TriplesIterator cc = ts.getStatements("!wine:CabernetSauvignonGrape",null, null);
		AGUtils.showTriples(cc);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
