package com.franz.agjena.examples;


import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.examples.AGPaths;
import com.franz.agjena.AllegroGraphGraphMaker;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class AGJenaGraphMakerInterface {

	/**
	 * Demonstrates the Jena GraphMaker interface to AllegroGraph.
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create fresh triple stores
		AllegroGraph ts1 = ags.renew("store1", AGPaths.TRIPLE_STORES);
		AllegroGraph ts2 = ags.renew("store2", AGPaths.TRIPLE_STORES);

		// Create a GraphMaker (a Graph factory) for each store.
	    GraphMaker maker1 = new AllegroGraphGraphMaker(ts1);
	    GraphMaker maker2 = new AllegroGraphGraphMaker(ts2);
	    
	    // Show the default graph for maker1
	    Graph defaultGraph1 = maker1.getGraph();
	    showGraphName(defaultGraph1);
	    
	    // Show the default graph for maker2
	    Graph defaultGraph2 = maker2.getGraph();
	    showGraphName(defaultGraph2);
	    
	    // Show an anonymous graph for maker1
	    Graph anonGraph1a = maker1.createGraph();
	    showGraphName(anonGraph1a);
	    
	    // Show another anonymous graph for maker1
	    Graph anonGraph1b = maker1.createGraph();
	    showGraphName(anonGraph1b);
	    
	    // Show an anonymous graph for maker2
	    Graph anonGraph2a = maker2.createGraph();
	    showGraphName(anonGraph2a);
	    
	    // Show another anonymous graph for maker2
	    Graph anonGraph2b = maker2.createGraph();
	    showGraphName(anonGraph2b);
	    
	    // Show a named graph foo in maker1
	    Graph foo1 = maker1.createGraph("http://example.org/foo", true);
	    showGraphName(foo1);
 
	    // Try to strict-create another named graph foo in maker1
	    // Uncommenting this should throw an exception.
	    /*
	    try {
	    	Graph foo1b = maker1.createGraph("http://example.org/foo", true);
	    	showGraph(foo1b);
	    } catch (Exception e) {
	    	System.out.println("This is an expected exception: ");
	    	e.printStackTrace();
	    }
	    */
 
	    // Show a named graph foo in maker2
	    Graph foo2 = maker2.createGraph("http://example.org/foo", true);
	    showGraphName(foo2);
 
	    // List the graphs in maker1 
	    ExtendedIterator it1 = maker1.listGraphs();
	    while (it1.hasNext()) {
	    	System.out.println(it1.next());
	    }
	    
	    // List the graphs in maker2 
	    ExtendedIterator it2 = maker2.listGraphs();
	    while (it2.hasNext()) {
	    	System.out.println(it2.next());
	    }
	    
	    // Show the default reification style
	    ReificationStyle rs = maker1.getReificationStyle();
	    System.out.println("ReificationStyle: " + rs.toString());
	    
		// Close the triple stores and disconnect from the server
		ts1.closeTripleStore();
		ts2.closeTripleStore();
		ags.disable();
	}

	public static void showGraphName(Graph g) {
	    System.out.println(g.toString());
	}
}
