package com.franz.agjena;

import java.util.List;

import com.franz.agbase.AllegroGraphException;
import com.franz.agjena.exceptions.NiceException;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;

public class AGBulkUpdateHandler extends SimpleBulkUpdateHandler implements
		BulkUpdateHandler {

	public AGBulkUpdateHandler(GraphWithPerform graph) {
		super(graph);
	}
	
	private String[] makeArray ( String[] old, int batch ) {
		if ( old==null ) return new String[batch];
		if ( batch==old.length ) return old;
		return new String[batch];
	}
	
	private void setArrays ( AllegroGraphGraph agg, Triple t, int j, 
			String[] s, String[] p, String[] o, String[] c ) {
		JenaToAGManager j2ag = agg.getJ2AG();
		s[j] = j2ag.jenaNodeToAgStringTerm(t.getSubject());
		p[j] = j2ag.jenaNodeToAgStringTerm(t.getPredicate());
		o[j] = j2ag.jenaNodeToAgStringTerm(t.getObject());		
		c[j] = agg.getContextArgumentString();	
	}

	@SuppressWarnings("unchecked")
	@Override
	protected void add(List triples, boolean notify) {
		perform(triples, null, false, notify);
		}
	
	@SuppressWarnings("unchecked")
	protected void delete(List triples, boolean notify) {
		perform(triples, null, true, notify);
		}

	@Override
	public void add(Triple[] triples) {
		perform(null, triples, false, true);
		}
	
	public void delete(Triple[] triples) {
		perform(null, triples, true, true);
	}
	
	private void perform(List<Triple> triplesList, Triple[] triplesArray, boolean del,  boolean notify) {
		int count = 0;
		if ( null==triplesList ) count = triplesArray.length;
		if ( null==triplesArray ) count = triplesList.size();
		
		AllegroGraphGraph agg = (AllegroGraphGraph) graph;
		int sl = agg.getAllegroGraphStore().getSelectLimit();
		if ( sl<1000 ) sl = 1000;
		
		String[] s = null;
		String[] p = null;
		String[] o = null;
		String[] c = null;
		
		int i = 0; int left = count;
		while (0<left) {
			int batch = (left<sl)?left:sl;
			
			s = makeArray(s, batch);
			p = makeArray(p, batch);
			o = makeArray(o, batch);
			c = makeArray(c, batch);
			
			for (int j = 0; j < batch; j++) {
				Triple t = null;
				if ( null==triplesArray ) t = triplesList.get(i);
				if ( null==triplesList )  t = triplesArray[i];
				setArrays(agg, t, j, s, p, o, c);
				i++;
			}
			try {
				if ( del )
					agg.getAGConnector().delete(agg.getAllegroGraphStore(), s, p, o, c, false);
				else
					agg.getAGConnector().addTriples(agg.getAllegroGraphStore(), s, p, o, c);
			} catch (AllegroGraphException e) {
				throw new NiceException(e);
			}
			left = left - batch;
		}
		
		if ( null==triplesArray ) 
			{ if (notify) 
				{
				if ( del )
					manager.notifyDeleteList( graph, triplesList );
				else
					manager.notifyAddList( graph, triplesList ); }
				}
		if ( null==triplesList )
			{
				if ( del )
					manager.notifyDeleteArray( graph, triplesArray );
				else
					manager.notifyAddArray( graph, triplesArray );
			}
	}

}
