/*
 * Decompiled with CFR 0.152.
 */
package com.franz.ag;

import com.franz.ag.AllegroGraph;
import com.franz.ag.AllegroGraphException;
import com.franz.ag.Cursor;
import com.franz.ag.GeospatialSubtype;
import com.franz.ag.UPI;
import com.franz.ag.impl.AGFactory;
import com.franz.ag.impl.CursorImpl;
import com.franz.ag.impl.GeospatialSubtypeImpl;
import com.franz.agbase.transport.AGConnector;

public class GeoExtension {
    private AllegroGraph ag = null;

    GeoExtension(AllegroGraph allegroGraph) {
        this.ag = allegroGraph;
    }

    public GeospatialSubtype registerCartesianStriping(double d, double d2, double d3, double d4, double d5) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-register-striping", new Object[]{"cartesian", new Double(d), new Double(d2), new Double(d3), new Double(d4), new Double(d5)});
        return this.registeredStriping(objectArray);
    }

    GeospatialSubtype registeredStriping(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (1 > objectArray.length) {
            return null;
        }
        return GeospatialSubtypeImpl.get(AGConnector.longValue(objectArray[0]), this.ag);
    }

    public GeospatialSubtype registerLatitudeStripingInDegrees(double d) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-register-striping", new Object[]{"degrees", new Double(d)});
        return this.registeredStriping(objectArray);
    }

    public GeospatialSubtype registerLatitudeStripingInDegrees(double d, Double d2, Double d3, Double d4, Double d5) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-register-striping", new Object[]{"degrees", new Double(d), "lat-min", d2, "lat-max", d3, "lon-min", d4, "lon-max", d5});
        return this.registeredStriping(objectArray);
    }

    public GeospatialSubtype registerLatitudeStripingInMiles(double d) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-register-striping", new Object[]{"miles", new Double(d)});
        return this.registeredStriping(objectArray);
    }

    public GeospatialSubtype registerLatitudeStripingInMiles(double d, Double d2, Double d3, Double d4, Double d5) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-register-striping", new Object[]{"miles", new Double(d), "lat-min", d2, "lat-max", d3, "lon-min", d4, "lon-max", d5});
        return this.registeredStriping(objectArray);
    }

    public GeospatialSubtype registerLatitudeStripingInKm(double d) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-register-striping", new Object[]{"km", new Double(d)});
        return this.registeredStriping(objectArray);
    }

    public GeospatialSubtype registerLatitudeStripingInKm(double d, Double d2, Double d3, Double d4, Double d5) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-register-striping", new Object[]{"km", new Double(d), "lat-min", d2, "lat-max", d3, "lon-min", d4, "lon-max", d5});
        return this.registeredStriping(objectArray);
    }

    public GeospatialSubtype registerLatitudeStripingInRadians(double d) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-register-striping", new Object[]{"radians", new Double(d)});
        return this.registeredStriping(objectArray);
    }

    public GeospatialSubtype registerLatitudeStripingInRadians(double d, Double d2, Double d3, Double d4, Double d5) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-register-striping", new Object[]{"radians", new Double(d), "lat-min", d2, "lat-max", d3, "lon-min", d4, "lon-max", d5});
        return this.registeredStriping(objectArray);
    }

    public void addSubtype(GeospatialSubtype geospatialSubtype) throws AllegroGraphException {
        this.ag.applyAGFn("ag-add-subtype", new Object[]{((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags)});
    }

    public UPI encodeUPI(GeospatialSubtype geospatialSubtype, double d, double d2) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-encode-geoupi", new Object[]{((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags), new Double(d), new Double(d2)});
        return (UPI)objectArray[0];
    }

    public UPI[] encodeUPIs(GeospatialSubtype geospatialSubtype, double[] dArray, double[] dArray2) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-encode-geoupi", new Object[]{((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags), dArray, dArray2});
        return (UPI[])objectArray[0];
    }

    public UPI[] encodeUPIs(GeospatialSubtype geospatialSubtype, double d, double[] dArray) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-encode-geoupi", new Object[]{((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags), new Double(d), dArray});
        return (UPI[])objectArray[0];
    }

    public UPI[] encodeUPIs(GeospatialSubtype geospatialSubtype, double[] dArray, double d) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-encode-geoupi", new Object[]{((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags), dArray, new Double(d)});
        return (UPI[])objectArray[0];
    }

    public UPI[] encodeUPIs(GeospatialSubtype geospatialSubtype, double[] dArray) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-encode-geoupi", new Object[]{((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags), "longlat", dArray});
        return (UPI[])objectArray[0];
    }

    public Object[] decodeUPI(UPI uPI) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-decode-geoupi", new Object[]{uPI});
        objectArray[0] = GeospatialSubtypeImpl.get((long)((Long)objectArray[0]), this.ag);
        return objectArray;
    }

    public Object[] decodeUPIs(UPI[] uPIArray) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-decode-geoupi", new Object[]{uPIArray});
        Object object = objectArray[0];
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            GeospatialSubtype[] geospatialSubtypeArray = new GeospatialSubtype[byArray.length];
            for (int i = 0; i < geospatialSubtypeArray.length; ++i) {
                geospatialSubtypeArray[i] = GeospatialSubtypeImpl.get((long)byArray[i], this.ag);
            }
            objectArray[0] = geospatialSubtypeArray;
        } else {
            objectArray[0] = GeospatialSubtypeImpl.get(AGConnector.longValue(objectArray[0]), this.ag);
        }
        return objectArray;
    }

    private Integer lookAheadArg() {
        int n = this.ag.defaultLookAhead;
        if (n < 1) {
            n = CursorImpl.defaultLookAhead;
        }
        return new Integer(n);
    }

    private Cursor geoCursor(Object[] objectArray) {
        if (objectArray == null || 2 > objectArray.length) {
            return this.ag.emptyCursor();
        }
        return AGFactory.makeCursor(this.ag, objectArray[0], AGConnector.toUPIArray(objectArray[1]));
    }

    public Cursor getStatementsInBoundingBox(GeospatialSubtype geospatialSubtype, Object object, double d, double d2, double d3, double d4, boolean bl, boolean bl2) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-get-geo-in-box", new Object[]{((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags), this.ag.validRef(object), new Double(d), new Double(d2), new Double(d3), new Double(d4), "indexed-only", bl ? "" : null, "include-deleted", bl2 ? "" : null, "look-ahead", this.lookAheadArg()});
        return this.geoCursor(objectArray);
    }

    private Cursor getGeoStatements(String string, GeospatialSubtype geospatialSubtype, Object object, double d, double d2, double d3, boolean bl, boolean bl2) throws AllegroGraphException {
        Object[] objectArray = this.ag.applyAGFn("ag-get-geo-triples", new Object[]{string, ((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags), this.ag.validRef(object), new Double(d), new Double(d2), new Double(d3), "indexed-only", bl ? "" : null, "include-deleted", bl2 ? "" : null, "look-ahead", this.lookAheadArg()});
        return this.geoCursor(objectArray);
    }

    public Cursor getStatementsInRadius(GeospatialSubtype geospatialSubtype, Object object, double d, double d2, double d3, boolean bl, boolean bl2) throws AllegroGraphException {
        return this.getGeoStatements("radius", geospatialSubtype, object, d, d2, d3, bl, bl2);
    }

    public Cursor getStatementsInHMiles(GeospatialSubtype geospatialSubtype, Object object, double d, double d2, double d3, boolean bl, boolean bl2) throws AllegroGraphException {
        return this.getGeoStatements("hmi", geospatialSubtype, object, d, d2, d3, bl, bl2);
    }

    public Cursor getStatementsInHKm(GeospatialSubtype geospatialSubtype, Object object, double d, double d2, double d3, boolean bl, boolean bl2) throws AllegroGraphException {
        return this.getGeoStatements("hkm", geospatialSubtype, object, d, d2, d3, bl, bl2);
    }

    public Cursor getStatementsInHRadians(GeospatialSubtype geospatialSubtype, Object object, double d, double d2, double d3, boolean bl, boolean bl2) throws AllegroGraphException {
        return this.getGeoStatements("hrad", geospatialSubtype, object, d, d2, d3, bl, bl2);
    }

    public void addSphericalPredicateMapping(String string, GeospatialSubtype geospatialSubtype) throws AllegroGraphException {
        this.ag.applyAGFn("ag-add-geo-mapping", new Object[]{"sph-pred", string, ((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags)});
    }

    public void addSphericalDatatypeMapping(String string, GeospatialSubtype geospatialSubtype) throws AllegroGraphException {
        this.ag.applyAGFn("ag-add-geo-mapping", new Object[]{"sph-type", string, ((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags)});
    }

    public void addCartesianPredicateMapping(String string, GeospatialSubtype geospatialSubtype) throws AllegroGraphException {
        this.ag.applyAGFn("ag-add-geo-mapping", new Object[]{"cart-pred", string, ((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags)});
    }

    public void addCartesianDatatypeMapping(String string, GeospatialSubtype geospatialSubtype) throws AllegroGraphException {
        this.ag.applyAGFn("ag-add-geo-mapping", new Object[]{"cart-type", string, ((GeospatialSubtypeImpl)geospatialSubtype).getLocal(this.ag.agbase.ags)});
    }

    public GeospatialSubtype[] getSubtypes() throws AllegroGraphException {
        Object[] objectArray = this.ag.verifyEnabled().applyAGFn(this.ag, "agj-geospatial-subtypes", new Object[0]);
        if (objectArray == null) {
            return new GeospatialSubtype[0];
        }
        if (0 == objectArray.length) {
            return new GeospatialSubtype[0];
        }
        Object object = objectArray[0];
        if (!(object instanceof String[])) {
            return new GeospatialSubtype[0];
        }
        String[] stringArray = (String[])object;
        GeospatialSubtype[] geospatialSubtypeArray = new GeospatialSubtype[stringArray.length / 2];
        for (int i = 0; i < stringArray.length; i += 2) {
            long l = Long.parseLong(stringArray[i]);
            GeospatialSubtypeImpl geospatialSubtypeImpl = (GeospatialSubtypeImpl)GeospatialSubtypeImpl.get(l, this.ag);
            geospatialSubtypeImpl.setUUID(stringArray[i + 1]);
            geospatialSubtypeArray[i / 2] = geospatialSubtypeImpl;
        }
        return geospatialSubtypeArray;
    }
}

