/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.ag.AllegroGraphException;
import com.franz.ag.NamespaceRegistry;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.impl.TriplesIteratorImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGBase;
import com.franz.agbase.util.AGConnInternals;
import com.franz.agbase.util.AGInternals;
import java.io.IOException;
import java.util.prefs.Preferences;

public class AllegroGraphConnection
extends AGConnInternals {
    private Process agp;

    public static NamespaceRegistry getInitialNamespaceRegistry() {
        return initialns;
    }

    public static void setInitialNamespaceRegistry(NamespaceRegistry namespaceRegistry) {
        initialns = new NamespaceRegistry(namespaceRegistry);
    }

    public static int getDefaultPollCount() {
        return defaultPollCount;
    }

    public static int getDefaultPollInterval() {
        return defaultPollInterval;
    }

    public int getPollCount() {
        return this.pollCount;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public static void setDefaultPolling(int n, int n2) {
        if (n > 0) {
            defaultPollCount = n;
        }
        if (n2 > 0) {
            defaultPollInterval = n2;
        }
    }

    public void setPolling(int n, int n2) {
        if (n >= 0) {
            int n3 = this.pollCount = n > 0 ? n : defaultPollCount;
        }
        if (n2 >= 0) {
            this.pollInterval = n2 > 0 ? n2 : defaultPollInterval;
        }
    }

    protected AGConnector getAgc(AllegroGraphConnection allegroGraphConnection) {
        return allegroGraphConnection.agc;
    }

    public static String getDefaultMode() {
        return defaultMode;
    }

    public String getMode() {
        return this.mode;
    }

    public static int getDefaultPort() {
        return defaultPort;
    }

    public static void setDefaultPort(int n) {
        defaultPort = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public static int getDefaultPort2() {
        return defaultPort2;
    }

    public static void setDefaultPort2(int n) {
        defaultPort2 = n;
    }

    public int getPort2() {
        return this.port2;
    }

    public void setPort2(int n) {
        this.port2 = n;
    }

    public static String getDefaultHost() {
        return defaultHost;
    }

    public static void setDefaultHost(String string) {
        defaultHost = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public static int getDefaultDebug() {
        return defaultDebug;
    }

    public static void setDefaultDebug(int n) {
        defaultDebug = n;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public static String getDefaultCommand() {
        return defaultLispCommand;
    }

    public static void setDefaultCommand(String string) {
        if (string == null) {
            throw new IllegalArgumentException("command cannot be null");
        }
        defaultLispCommand = string;
    }

    public String getCommand() {
        return this.lispCommand;
    }

    public void setCommand(String string) {
        if (string == null) {
            throw new IllegalArgumentException("command cannot be null");
        }
        this.lispCommand = string;
    }

    public static boolean getDefaultServerKeep() {
        return defaultServerKeep;
    }

    public void setDefaultServerKeep(boolean bl) {
        defaultServerKeep = bl;
    }

    public boolean getServerKeep() {
        return this.keep;
    }

    public void setServerKeep(boolean bl) {
        this.keep = bl;
    }

    public boolean enable() throws IOException, AllegroGraphException {
        if (this.agc == null) {
            this.agc = AGConnector.createConnector(this.mode);
        } else if (-1 < this.agc.query()) {
            return false;
        }
        this.agc.init(this.port, this.port2, this.host, this.pollCount, this.pollInterval, this.debug, this.timeout);
        this.agc.enable();
        if (this.debug > 0) {
            this.serverTrace(true);
        }
        Object var1_1 = null;
        int n = 0;
        Object object = null;
        try {
            object = this.agc.serverOptionOne("client-debug", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (var1_1 != null) {
            n = AGConnector.toInt(object);
        }
        int n2 = 0;
        try {
            object = this.agc.serverOptionOne("client-batch", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null) {
            n2 = AGConnector.toInt(object);
        }
        if (n2 > 0) {
            TriplesIteratorImpl.defaultLookAhead = n2;
        }
        int n3 = 0;
        try {
            object = this.agc.serverOptionOne("server-level", 9);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null) {
            n3 = AGConnector.toInt(object);
        }
        if (n3 < 7) {
            throw new AllegroGraphException("AllegroGraph server is out of date: " + n3 + "<" + 7);
        }
        if (n3 > 7) {
            throw new AllegroGraphException("Library agraph.jar is out of date: " + n3 + ">" + 7);
        }
        try {
            this.agc.serverOptionOne("client-level", 7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.debugMask = n | 0x40000000;
        this.serverId = this.agc.serverId();
        if (this.serverId < 101L) {
            throw new AllegroGraphException("AllegroGraph server is out of date serverId: " + this.serverId);
        }
        this.freshState();
        return true;
    }

    public int interrupt() throws AllegroGraphException, IOException {
        long l = this.serverId;
        if (l < 0L) {
            return -10;
        }
        if (l == 0L) {
            return -9;
        }
        if (l < 101L) {
            return -8;
        }
        if (!this.isEnabled()) {
            return -7;
        }
        int n = 0;
        if (this.isBusy()) {
            AllegroGraphConnection allegroGraphConnection = new AllegroGraphConnection();
            allegroGraphConnection.setHost(this.getHost());
            allegroGraphConnection.setPort(this.getPort());
            allegroGraphConnection.enable();
            n = allegroGraphConnection.agc.interruptServer(l);
            allegroGraphConnection.disable(false);
        }
        return n;
    }

    public void disable() {
        this.disable(true);
    }

    public synchronized void disable(boolean bl) {
        this.getServer();
        Object[] objectArray = this.arrayOfTS();
        if (bl) {
            for (int i = 0; i < objectArray.length; ++i) {
                AGBase aGBase = (AGBase)objectArray[i];
                if (aGBase.tsx < 0) continue;
                try {
                    this.agc.closeTripleStore(aGBase, true);
                    aGBase.tsx = -1;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.agc != null && -1 < this.agc.query()) {
            this.agc.disable();
        }
        this.agc = null;
        this.serverId = 0L;
    }

    protected void finalize() throws AllegroGraphException, IOException {
        this.disable(true);
        if (!this.keep) {
            this.stopServer();
        }
    }

    public boolean isEnabled() {
        if (this.agc == null) {
            return false;
        }
        return -1 < this.agc.query();
    }

    public boolean isBusy() {
        if (this.agc == null) {
            return false;
        }
        return 0 < this.agc.query();
    }

    public AllegroGraph create(String string, String string2) throws AllegroGraphException {
        return new AllegroGraph(this, "create", string, string2);
    }

    public AGInternals create(AllegroGraph allegroGraph) throws AllegroGraphException {
        allegroGraph.connect(this, "create");
        return allegroGraph;
    }

    public AllegroGraph open(String string, String string2) throws AllegroGraphException {
        return new AllegroGraph(this, "open", string, string2);
    }

    public AllegroGraph open(AllegroGraph allegroGraph) throws AllegroGraphException {
        allegroGraph.connect(this, "open");
        return allegroGraph;
    }

    public boolean exists(String string, String string2) throws AllegroGraphException {
        return this.getServer().exists(string, string2);
    }

    public AllegroGraph access(String string, String string2) throws AllegroGraphException {
        return new AllegroGraph(this, "access", string, string2);
    }

    public AGInternals access(AllegroGraph allegroGraph) throws AllegroGraphException {
        allegroGraph.connect(this, "access");
        return allegroGraph;
    }

    public AllegroGraph renew(String string, String string2) throws AllegroGraphException {
        return new AllegroGraph(this, "renew", string, string2);
    }

    public AllegroGraph renew(AllegroGraph allegroGraph) throws AllegroGraphException {
        allegroGraph.connect(this, "renew");
        return allegroGraph;
    }

    public AllegroGraph replace(String string, String string2) throws AllegroGraphException {
        return new AllegroGraph(this, "replace", string, string2);
    }

    public AGInternals replace(AllegroGraph allegroGraph) throws AllegroGraphException {
        allegroGraph.connect(this, "replace");
        return allegroGraph;
    }

    public long getChunkSize() throws AllegroGraphException {
        Object object = this.getServer().serverOptionOne("chunk-size", -1);
        if (object != null) {
            return AGConnector.longValue(object);
        }
        throw new AllegroGraphException("Cannot get chunk size.");
    }

    public void setChunkSize(long l) throws AllegroGraphException {
        if (l < 1L) {
            throw new IllegalArgumentException("ChunkSize must be positive.");
        }
        this.getServer().serverOptionOne("chunk-size", l);
    }

    public long getDefaultExpectedResources() throws AllegroGraphException {
        Object object = this.getServer().serverOptionOne("expected", -1);
        if (object != null) {
            return AGConnector.longValue(object);
        }
        throw new AllegroGraphException("Cannot get expected resource number.");
    }

    public void setDefaultExpectedResources(long l) throws AllegroGraphException {
        if (l < 1L) {
            throw new IllegalArgumentException("ExpectedResources must be positive.");
        }
        this.getServer().serverOptionOne("expected", l);
    }

    public Object[] evalInServer(String string) throws AllegroGraphException {
        return this.getServer().evalInServer(string);
    }

    public int serverTrace(boolean bl) {
        try {
            this.getServer().serverTrace(bl, null);
            return 0;
        }
        catch (AllegroGraphException allegroGraphException) {
            return -1;
        }
    }

    public boolean serverLevel(int n) throws AllegroGraphException {
        return this.getServer().serverLevel(n);
    }

    public int serverTrace(String string) {
        try {
            this.getServer().serverTrace(true, string);
            return 0;
        }
        catch (AllegroGraphException allegroGraphException) {
            return -1;
        }
    }

    public void serverTimers(boolean bl, boolean bl2) throws AllegroGraphException {
        this.getServer().serverTimers(null, bl, bl2);
    }

    public long[] getTimers() throws AllegroGraphException {
        return this.getServer().getTimers(null);
    }

    public String[] getNamespaces() {
        if (this.nsregs == null) {
            return null;
        }
        return this.nsregs.toArray();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        if (null == this.nsregs) {
            return null;
        }
        return new NamespaceRegistry(this.nsregs);
    }

    private NamespaceRegistry nsregsInit() {
        if (this.nsregs != null) {
            return this.nsregs;
        }
        if (initialns == null) {
            throw new IllegalStateException("The default NamespaceRegistry is suppressed in this instance of AllegroGraphConnection");
        }
        this.nsregs = new NamespaceRegistry(initialns);
        return this.nsregs;
    }

    public void registerNamespace(String string, String string2) {
        this.nsregsInit().register(string, string2);
    }

    public void registerNamespaces(String[] stringArray) {
        this.nsregsInit();
        for (int i = 0; i < stringArray.length; i += 2) {
            this.nsregs.register(stringArray[i], stringArray[i + 1]);
        }
    }

    public void registerNamespaces(NamespaceRegistry namespaceRegistry) {
        this.nsregsInit().register(namespaceRegistry);
    }

    public void setNamespaceRegistry(NamespaceRegistry namespaceRegistry) {
        this.nsregs = namespaceRegistry == null ? null : new NamespaceRegistry(namespaceRegistry);
    }

    public String toString() {
        return this.getClass().getName() + "<" + this.serverId + " " + this.mode + ">";
    }

    public void startServer() throws IOException {
        this.startServer(null);
    }

    public void startServer(String string) throws IOException {
        Object object;
        Object object2;
        if (this.lispCommand == null) {
            this.lispCommand = "";
        }
        String string2 = System.getProperty("com.franz.ag.exec", this.lispCommand);
        if ("".equals(this.lispCommand)) {
            this.lispCommand = string2;
        }
        if (" ".equals(this.lispCommand)) {
            if (string2.equals("")) {
                object2 = Preferences.userRoot();
                object = ((Preferences)object2).node("franz.com/allegrograph/java");
                string2 = ((Preferences)object).get("lispcommand", "");
            }
            if (string2.equals("")) {
                object2 = Preferences.systemRoot();
                object = ((Preferences)object2).node("franz.com/allegrograph/java");
                string2 = ((Preferences)object).get("lispcommand", "");
            }
            defaultLispCommand = string2;
            this.lispCommand = string2;
        }
        if (this.agp != null) {
            throw new IllegalStateException("Already started");
        }
        if (null == this.lispCommand || "".equals(this.lispCommand) || " ".equals(this.lispCommand)) {
            throw new IllegalStateException("ACL command must be set");
        }
        object2 = "";
        object = "";
        if (string != null) {
            object2 = "--log-file";
            object = string;
        }
        String[] stringArray = new String[]{this.lispCommand, "--port", "" + this.port, object2, object};
        if (this.debug > 0) {
            String string3 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = string3 + " " + stringArray[i];
            }
            System.out.println("startServer command:" + string3);
        }
        this.agp = Runtime.getRuntime().exec(stringArray);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int stopServer() throws IOException {
        return this.stopServer(false);
    }

    public int stopServer(boolean bl) throws IOException {
        int n = 0;
        if (this.debug > 0) {
            System.out.println("stopServer: " + this.agp + " " + this.agc);
        }
        if (this.agp == null && !bl) {
            return -1;
        }
        if (this.agc == null) {
            try {
                if (this.debug > 0) {
                    System.out.println("stopServer calling enable");
                }
                boolean bl2 = this.enable();
                if (this.debug > 0) {
                    System.out.println("stopServer enable returned " + bl2);
                }
            }
            catch (Exception exception) {
                if (this.debug > 0) {
                    System.out.println("connect " + exception);
                }
                this.agc = null;
                ++n;
            }
        }
        if (this.agc != null) {
            if (0 > this.agc.query()) {
                if (this.debug > 0) {
                    System.out.println("stopServer calling re-enable");
                }
                this.agc.enable();
            }
            if (-1 < this.agc.query()) {
                Object object;
                if (this.debug > 0) {
                    System.out.println("stopServer calling stop-agj-application");
                }
                String string = "";
                try {
                    object = this.agc.serverOptionOne("stop-app", "");
                }
                catch (Exception exception) {
                    object = "ERROR: " + exception;
                    ++n;
                }
                if (object instanceof String) {
                    string = (String)object;
                } else if (null != object) {
                    string = "ERROR: odd type " + object;
                    ++n;
                }
                if (this.debug > 0) {
                    System.out.println("stopServer stop-agj-ap => " + string);
                }
                if (this.debug > 0) {
                    System.out.println("stopServer calling disable");
                }
                this.disable();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            } else if (this.debug > 0) {
                System.out.println("stopServer re-enable failed");
            }
        }
        if (this.agp != null) {
            if (this.debug > 0) {
                System.out.println("stopServer calling destroy");
            }
            this.agp.destroy();
            try {
                this.agp.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = "";
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).equalsIgnoreCase("-system")) {
                string = stringArray[++i];
                continue;
            }
            if (!((String)object).equalsIgnoreCase("-user")) continue;
            string2 = stringArray[++i];
        }
        Preferences preferences = Preferences.systemRoot();
        object = preferences.node("franz.com/allegrograph/java");
        String string3 = ((Preferences)object).get("lispcommand", "");
        String string4 = "System value of franz.com/allegrograph/java/lispcommand";
        if (string3.equals("")) {
            System.out.println("Current " + string4 + " is unset.");
        } else {
            System.out.println("Current " + string4 + " is " + string3);
        }
        Preferences preferences2 = Preferences.userRoot();
        Preferences preferences3 = preferences2.node("franz.com/allegrograph/java");
        String string5 = preferences3.get("lispcommand", "");
        String string6 = "User value of franz.com/allegrograph/java/lispcommand";
        if (string5.equals("")) {
            System.out.println("Current " + string6 + " is unset.");
        } else {
            System.out.println("Current " + string6 + " is " + string5);
        }
        if (!string.equals("")) {
            ((Preferences)object).put("lispcommand", string);
            System.out.println("Modified " + string4 + " to " + string);
        }
        if (!string2.equals("")) {
            preferences3.put("lispcommand", string2);
            System.out.println("Modified " + string6 + " to " + string2);
        }
    }

    public AllegroGraph federate(String string, AGInternals[] aGInternalsArray, boolean bl) throws AllegroGraphException {
        return new AllegroGraph(this, string, aGInternalsArray, bl);
    }

    public AllegroGraph findStore(String string) throws AllegroGraphException {
        return new AllegroGraph(this, string, null);
    }

    public AGInternals findStore(String string, String string2) throws AllegroGraphException {
        return new AllegroGraph(this, string, string2);
    }

    public void deleteStore(String string) throws AllegroGraphException {
        this.deleteStore(string, null);
    }

    public void deleteStore(String string, String string2) throws AllegroGraphException {
        this.getServer().findStore(string, string2, "delete");
    }

    public static int getDefaultTimeout() {
        return defaultTimeout;
    }

    public static void setDefaultTimeout(int n) {
        defaultTimeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public long getDefaultSPOGICacheSize() throws AllegroGraphException {
        Object object = AllegroGraphConnection.serverOption(this, "spogi-cache-size", -1);
        return AGConnector.longValue(object);
    }

    public void setDefaultSPOGICacheSize(long l) throws AllegroGraphException {
        AllegroGraphConnection.serverOption(this, "spogi-cache-size", l);
    }
}

