/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.ag.AllegroGraphException;
import com.franz.agbase.ValueObject;
import com.franz.agbase.ValueSetIterator;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.util.AGInternals;
import java.util.NoSuchElementException;

public class ValueSetIteratorImpl
implements ValueSetIterator {
    public ValueObject[][] sets = null;
    private int index = -3;
    private boolean indexUsable = true;
    private AGInternals ag = null;
    private Object savedToken = null;
    private boolean nullOk = false;
    private int savedMore = 0;
    private int savedPlimit = 0;
    private Object savedExtra = null;

    public ValueSetIteratorImpl() {
    }

    public ValueSetIteratorImpl(AGInternals aGInternals, boolean bl, ValueObject[][] valueObjectArray, Object object, int n, int n2, Object object2) {
        this.ag = aGInternals;
        this.sets = valueObjectArray;
        this.index = -1;
        this.nullOk = bl;
        this.savedToken = object;
        this.savedMore = n;
        this.savedPlimit = n2;
        this.savedExtra = object2;
    }

    public boolean hasNext() {
        if (this.sets == null) {
            return false;
        }
        if (this.index < -2) {
            return false;
        }
        if (this.index == -2) {
            return this.savedMore > 0;
        }
        if (this.index + 1 < this.sets.length) {
            return true;
        }
        return this.savedMore > 0;
    }

    private boolean canUseIndex() {
        if (this.sets == null) {
            return false;
        }
        if (this.index < 0) {
            return false;
        }
        return this.index < this.sets.length;
    }

    private boolean stepIndex() {
        if (this.sets == null) {
            return false;
        }
        if (this.index < -1) {
            return false;
        }
        ++this.index;
        this.indexUsable = true;
        if (this.index < this.sets.length) {
            return true;
        }
        this.index = -2;
        return false;
    }

    public ValueObject[] next() {
        if (this.sets == null || this.index < -1) {
            throw new NoSuchElementException("Empty iterator.");
        }
        if (this.stepIndex()) {
            return this.sets[this.index];
        }
        if (this.savedMore > 0) {
            try {
                this.sets = this.selectMoreInternal(this.sets);
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new NoSuchElementException("Server error " + allegroGraphException);
            }
            this.index = 0;
        }
        if (this.canUseIndex()) {
            return this.sets[this.index];
        }
        this.index = -4;
        throw new NoSuchElementException("Exhausted iterator.");
    }

    public void remove() {
        this.indexUsable = false;
    }

    private ValueObject[][] selectMoreInternal(ValueObject[][] valueObjectArray) throws AllegroGraphException {
        Object[] objectArray = this.ag.verifyEnabled().nextValuesArray(this.ag, this.savedToken, this.ag.selectLimit);
        if (objectArray == null) {
            return (ValueObject[][])this.ag.selectNull(false);
        }
        UPIImpl[] uPIImplArray = (UPIImpl[])objectArray[0];
        int[] nArray = (int[])objectArray[1];
        String[] stringArray = (String[])objectArray[2];
        String[] stringArray2 = (String[])objectArray[3];
        int n = (Integer)objectArray[4];
        int n2 = (Integer)objectArray[5];
        String string = (String)objectArray[6];
        int n3 = (Integer)objectArray[7];
        int n4 = uPIImplArray.length;
        int n5 = 0;
        if (n > 0) {
            this.savedToken = string;
            this.savedMore = n;
            this.savedPlimit = n3;
        } else {
            this.ag.ags.oldTokens.add(string);
            string = null;
        }
        if (n4 == n2 * valueObjectArray.length) {
            for (int i = 0; i < valueObjectArray.length; ++i) {
                ValueObject[] valueObjectArray2 = new ValueObject[n2];
                for (int j = 0; j < n2; ++j) {
                    valueObjectArray2[j] = this.ag.newSelectValue(this.nullOk, uPIImplArray[n5], nArray[n5], stringArray[n5], stringArray2[n5]);
                    ++n5;
                }
                valueObjectArray[i] = valueObjectArray2;
            }
            return valueObjectArray;
        }
        if (n2 == 0) {
            valueObjectArray = new ValueObject[n4][0];
        } else {
            int n6 = 0;
            n6 = n4 / n2;
            n5 = 0;
            int n7 = 0;
            valueObjectArray = new ValueObject[n6][n2];
            while (n5 < n4) {
                for (int i = 0; i < n2; ++i) {
                    valueObjectArray[n7][i] = this.ag.newSelectValue(this.nullOk, uPIImplArray[n5], nArray[n5], stringArray[n5], stringArray2[n5]);
                    ++n5;
                }
                ++n7;
            }
        }
        this.ag.discardOldTokens(false);
        return valueObjectArray;
    }

    public ValueObject[] get() {
        if (!this.indexUsable) {
            return null;
        }
        if (!this.canUseIndex()) {
            return null;
        }
        return this.sets[this.index];
    }

    public ValueObject get(int n) {
        ValueObject[] valueObjectArray = this.get();
        if (valueObjectArray == null) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        if (n < valueObjectArray.length) {
            return valueObjectArray[n];
        }
        return null;
    }

    public ValueObject next(int n) {
        this.next();
        return this.get(n);
    }

    public int width() {
        if (this.canUseIndex()) {
            return this.sets[this.index].length;
        }
        if (this.savedExtra instanceof String[]) {
            return ((String[])this.savedExtra).length;
        }
        if (this.sets != null && 0 < this.sets.length) {
            return this.sets[0].length;
        }
        return -1;
    }

    public long getCount() {
        long l = 0L;
        if (this.canUseIndex()) {
            l = this.sets.length - this.index;
        } else if (this.sets != null) {
            l = this.sets.length;
        }
        l += (long)this.savedMore;
        if (this.savedMore > this.savedPlimit) {
            return -l;
        }
        return l;
    }

    public String[] getNames() {
        if (this.savedExtra instanceof String[]) {
            return (String[])this.savedExtra;
        }
        return new String[0];
    }
}

