/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.transport;

import com.franz.ag.UPI;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.transport.AGDirectLink;
import com.franz.agbase.transport.AGDirectLinkDebug;
import java.io.IOException;
import java.util.Arrays;

public class AGDTest {
    static int fail = 0;
    static int ldb = -1;
    static int javad = 0;
    static boolean verbose = false;

    static void dj(int n) {
        String string = AGDirectLink.debug(n);
        AGDTest.prv("Java debug " + string);
    }

    static void dl(AGDirectLink aGDirectLink, int n) {
        try {
            Object object = aGDirectLink.sendOp1(":debug", 1, 0, n);
            AGDTest.prv("Lisp debug now: " + object);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void pr(String string) {
        System.out.println(string);
    }

    static void prv(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        long l;
        int n;
        int n2;
        String string = "localhost";
        int n3 = 4567;
        int n4 = 500;
        int n5 = 1000;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].equalsIgnoreCase("-d")) {
                javad = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-p")) {
                n3 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-l")) {
                ldb = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-n")) {
                n4 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-a")) {
                n5 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-p1")) {
                bl = false;
                bl2 = true;
                bl3 = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-p2")) {
                bl = false;
                bl3 = true;
                bl2 = false;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-all")) continue;
            bl = true;
            bl3 = false;
            bl2 = false;
        }
        AGDTest.dj(javad);
        AGDirectLink aGDirectLink = javad > 0 ? new AGDirectLinkDebug(string, n3, 3, 1000) : new AGDirectLink(string, n3, 3, 1000);
        if (ldb > 0) {
            AGDTest.dl(aGDirectLink, ldb);
        }
        if (bl) {
            Object object = aGDirectLink.sendOp0(":verify", 1, -1);
            Object[] objectArray = (Object[])object;
            if (3 != objectArray.length) {
                throw new IOException(":verify length=" + objectArray.length);
            }
            if (!((String)objectArray[0]).equals(":verify")) {
                throw new IOException(":verify ra[0]=" + objectArray[0]);
            }
            object = aGDirectLink.sendOp1(":call", 1, 0, "user::test-0-1");
            if (!(object instanceof Long)) {
                throw new IOException(":call test-0-1 return type " + object);
            }
            if (17L != (Long)object) {
                throw new IOException(":call test-0-1 result " + (Long)object);
            }
            try {
                object = aGDirectLink.sendOp1(":call", 1, 0, "user::undefined");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AGDTest.pr("catch Lisp err: " + illegalArgumentException);
            }
            try {
                object = aGDirectLink.sendOp2(":call", 1, 0, "cl:car", 1L);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AGDTest.pr("catch Lisp err: " + illegalArgumentException);
            }
            object = aGDirectLink.sendOp1(":call", 1, -1, "cl:values");
            objectArray = (Object[])object;
            if (2 != objectArray.length) {
                throw new IOException(":call (values) r.length=" + objectArray.length);
            }
            for (int i = 0; i < 300; ++i) {
                AGDTest.test11(aGDirectLink, i);
                AGDTest.test11(aGDirectLink, -i);
            }
            AGDTest.test11(aGDirectLink, 100L);
            AGDTest.test11(aGDirectLink, 1000L);
            AGDTest.test11(aGDirectLink, 10000L);
            AGDTest.test11(aGDirectLink, 100000L);
            AGDTest.test11(aGDirectLink, 1000000L);
            AGDTest.test11(aGDirectLink, 10000000L);
            AGDTest.test11(aGDirectLink, 100000000L);
            AGDTest.test11(aGDirectLink, 1000000000L);
            AGDTest.test11(aGDirectLink, 10000000000L);
            AGDTest.test11(aGDirectLink, 10000000000000000L);
            AGDTest.test11(aGDirectLink, -345L);
            AGDTest.test11(aGDirectLink, -345234L);
            AGDTest.test11(aGDirectLink, -345345678L);
            AGDTest.test11(aGDirectLink, -34522222233333L);
            AGDTest.test11(aGDirectLink, -3457777777777777777L);
            AGDTest.test11(aGDirectLink, Long.MAX_VALUE);
            AGDTest.test11(aGDirectLink, Long.MIN_VALUE);
            AGDTest.test11u(aGDirectLink, new Float(123.4));
            AGDTest.test11u(aGDirectLink, new Double(123.4));
            AGDTest.test11u(aGDirectLink, new UPIImpl());
            AGDTest.test11u(aGDirectLink, new byte[]{1, 2, 3});
            AGDTest.test11u(aGDirectLink, new short[]{1, 2, 3});
            AGDTest.test11u(aGDirectLink, new int[]{1, 2, 3});
            AGDTest.test11u(aGDirectLink, new long[]{1L, 2L, 3L});
            AGDTest.test11u(aGDirectLink, new long[]{1L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 4L, 5L, 3L});
            AGDTest.test11u(aGDirectLink, new float[]{1.0f, 2.0f, 3.0f});
            AGDTest.test11u(aGDirectLink, new double[]{1.0, 2.0, 3.0});
            AGDTest.test11u(aGDirectLink, "string");
            AGDTest.test11u(aGDirectLink, "much longer string at least thirty two characters long");
            AGDTest.test11u(aGDirectLink, "much longer string at least thirty two characters long with a run 88888888888888888888888 of many 8's and 999999999999999999999999999999   and then some more");
            AGDTest.test11u(aGDirectLink, new String[]{"aa", "bb", "cc"});
            AGDTest.test11u(aGDirectLink, new String[]{"much longer string at least thirty two characters long with a run 88888888888888888888888 of many 8's and 999999999999999999999999999999   and then some more", "bb", "cc"});
            AGDTest.test11u(aGDirectLink, new String[]{null, "bb", "cc"});
            AGDTest.test11u(aGDirectLink, new String[]{"aa", null, "cc"});
            AGDTest.test11u(aGDirectLink, new String[]{"aa", "bb", null});
            AGDTest.test11u(aGDirectLink, new String[]{null, null, null});
            AGDTest.test11u(aGDirectLink, new UPIImpl[]{new UPIImpl(), new UPIImpl(), new UPIImpl()});
            AGDTest.test11u(aGDirectLink, new UPIImpl[]{new UPIImpl(), new UPIImpl(-1L), new UPIImpl(-2L)});
        }
        if (bl2) {
            AGDTest.dl(aGDirectLink, 0);
            long l2 = System.currentTimeMillis();
            n2 = 10 * n4;
            for (n = 0; n < n2; ++n) {
                aGDirectLink.sendOp0(":verify", 1, -1);
            }
            l = System.currentTimeMillis() - l2;
            AGDTest.pr("" + n2 + " calls to :verify " + l + " millisec.");
            AGDTest.pr("     " + (int)(1.0 / ((double)l * 0.001 * (1.0 / (double)n2))) + " calls per second.");
        }
        if (bl3) {
            AGDTest.dl(aGDirectLink, 0);
            int[] nArray = new int[n5];
            n2 = n4;
            for (n = 1; n < n5; ++n) {
                nArray[n] = 0x40000000 - n;
            }
            long l3 = System.currentTimeMillis();
            for (n = 0; n < n2; ++n) {
                aGDirectLink.sendOp2(":call", 1, 0, "user::test-1-1", nArray);
            }
            l = System.currentTimeMillis() - l3;
            AGDTest.pr("" + n2 + " calls with int[" + n5 + "] " + l + " millisec.");
            AGDTest.pr("     " + (int)(1.0 / ((double)l * 0.001 * (1.0 / (double)(n5 * n2)))) + " int round-trips per second.");
        }
        aGDirectLink.disconnect();
        System.exit(fail);
    }

    static void test11(AGDirectLink aGDirectLink, long l) throws IOException {
        Object object = aGDirectLink.sendOp2(":call", 1, 0, "user::test-1-1", l);
        if (!(object instanceof Long)) {
            throw new IOException(":call test-1-1 return type " + object);
        }
        if (l != (Long)object) {
            throw new IOException(":call test-1-1(" + l + ") result " + (Long)object);
        }
    }

    static void test11u(AGDirectLink aGDirectLink, Object object) throws IOException {
        Object object2 = aGDirectLink.sendOp2(":call", 1, 0, "user::test-1-1", object);
        if (object.getClass() != object2.getClass()) {
            throw new IOException(":call test-1-1(" + object + ") result " + object2);
        }
        if (object2 instanceof String && object.equals(object2)) {
            return;
        }
        if (object2 instanceof Float && object.equals(object2)) {
            return;
        }
        if (object2 instanceof Double && object.equals(object2)) {
            return;
        }
        if (object2 instanceof UPIImpl && object.equals(object2)) {
            return;
        }
        if (object2 instanceof byte[] && Arrays.equals((byte[])object, (byte[])object2)) {
            return;
        }
        if (object2 instanceof short[] && Arrays.equals((short[])object, (short[])object2)) {
            return;
        }
        if (object2 instanceof int[] && Arrays.equals((int[])object, (int[])object2)) {
            return;
        }
        if (object2 instanceof long[] && Arrays.equals((long[])object, (long[])object2)) {
            return;
        }
        if (object2 instanceof float[] && Arrays.equals((float[])object, (float[])object2)) {
            return;
        }
        if (object2 instanceof double[] && Arrays.equals((double[])object, (double[])object2)) {
            return;
        }
        if (object2 instanceof String[] && Arrays.equals((String[])object, (String[])object2)) {
            return;
        }
        if (object2 instanceof UPI[] && AGDTest.testUPI((UPI[])object, (UPI[])object2)) {
            return;
        }
        throw new IOException(":call AGDTest-1-1(" + object + ") result not equal " + object2);
    }

    static boolean testUPI(UPI[] uPIArray, UPI[] uPIArray2) {
        if (uPIArray.length != uPIArray2.length) {
            return false;
        }
        for (int i = 0; i < uPIArray2.length; ++i) {
            if (((Object)uPIArray[i]).equals(uPIArray2[i])) continue;
            return false;
        }
        return true;
    }
}

