/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.transport;

import com.franz.ag.UPI;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.util.AGC;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.InetSocketAddress;
import java.net.Socket;

public class AGDirectLink
extends AGC {
    protected static int debugClient = 0;
    int agServerLevel = 0;
    int state = -1;
    static final int ERR_PORT_CLOSED = -101;
    static final int ERR_PORT_STATE = -102;
    static final int ERR_PROTOCOL = -104;
    static final int ERR_PORT_IO = -107;
    static final int ERR_FLUSH_IO = -108;
    static final int ERR_THROW = -109;
    static final int ERR_BUSY = -111;
    Socket socket;
    InputStream inStream;
    OutputStream outStream;
    byte[] buffer = new byte[1024];
    int endpos = 0;
    Thread softLock = null;
    int timeout = 5000;
    static boolean connectFlag = false;
    static int opIndex = 0;
    int haveCode = 1000000;

    static void throwIOErr(String string, int n) throws IOException {
        String string2 = "Unknown";
        switch (n) {
            case -1: {
                string2 = "End_of_file";
                break;
            }
            case -102: {
                string2 = "ERR_PORT_STATE";
                break;
            }
            case -104: {
                string2 = "ERR_PROTOCOL";
                break;
            }
            case -107: {
                string2 = "ERR_PORT_IO";
                break;
            }
            case -108: {
                string2 = "ERR_FLUSH_IO";
                break;
            }
            case -109: {
                string2 = "ERR_THROW";
                break;
            }
            case -111: {
                string2 = "ERR_BUSY";
                break;
            }
            case -101: {
                string2 = "ERR_PORT_CLOSED";
                break;
            }
            default: {
                string2 = "Unknown err(" + n + ")";
            }
        }
        throw new IOException(string2 + " in " + string);
    }

    static String debug(int n) {
        int n2 = debugClient;
        if (n >= 0) {
            debugClient = n;
        }
        return "Client was " + n2 + " now " + debugClient;
    }

    AGDirectLink() {
    }

    AGDirectLink(String string, int n, int n2, int n3) throws IOException {
        this(string, n, n2, n3, 5000);
    }

    AGDirectLink(String string, int n, int n2, int n3, int n4) throws IOException {
        int n5;
        Socket socket = null;
        IOException iOException = null;
        for (n5 = 0; socket == null && n5 < n2; ++n5) {
            try {
                if (n5 > 0) {
                    Thread.sleep(n3);
                }
                Socket socket2 = new Socket();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
                socket2.connect(inetSocketAddress, n4);
                socket = socket2;
                continue;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (socket == null) {
            if (iOException == null) {
                throw new IOException("Failed to connect to server.");
            }
            throw new IOException(iOException.toString());
        }
        socket.setTcpNoDelay(true);
        this.socket = socket;
        this.inStream = socket.getInputStream();
        this.outStream = socket.getOutputStream();
        this.state = 0;
        this.softLock = null;
        n5 = n4 / 10;
        while (n5 > 0) {
            try {
                Thread.sleep(100L);
                --n5;
                if (0 >= this.inStream.available()) continue;
                n5 = -1;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (n5 == 0) {
            this.socket.close();
            throw new IOException("Connected but timed out.");
        }
        int n6 = this.inStream.read();
        switch (n6) {
            case 207: {
                this.socket.close();
                throw new IOException("Too many connections.");
            }
            case 192: {
                this.socket.close();
                throw new IOException("Connection rejected.");
            }
        }
        if (n6 != 130) {
            this.socket.close();
            throw new IOException("Unexpected initial reply " + n6);
        }
    }

    boolean query() throws IOException {
        String string;
        Object object = this.sendOp1(":verify", 1, 0, 2L);
        if (object instanceof String && (string = (String)object).startsWith("AGDirect Version")) {
            String string2 = "server level";
            int n = string.indexOf(string2);
            if (n < 0) {
                return true;
            }
            try {
                this.agServerLevel = Integer.parseInt(string.substring(n + string2.length() + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        this.disconnect();
        return false;
    }

    synchronized boolean disconnect() throws IOException {
        switch (this.state) {
            case -1: {
                return false;
            }
            case 0: {
                this.sendOp0(":disconnect", -1, -1);
                try {
                    Thread.sleep(100L);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            this.socket.close();
            this.state = -1;
            this.socket = null;
            this.inStream = null;
            this.outStream = null;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    synchronized String grabSoftLock(String string) {
        Thread thread = Thread.currentThread();
        if (this.softLock == null) {
            this.softLock = thread;
        } else {
            if (this.softLock == thread) {
                return "Recursive call to" + string;
            }
            while (this.softLock != null) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            this.softLock = thread;
        }
        return "";
    }

    synchronized void dropSoftLock() {
        if (this.softLock == null) {
            return;
        }
        this.softLock = null;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp0(String string, int n, int n2) throws IOException {
        try {
            int n3 = this.sendOpHeader(string, n, 0);
            Object object = this.sendOpTail(string, n3, n, n2);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp1(String string, int n, int n2, String string2) throws IOException {
        try {
            int n3 = this.sendOpHeader(string, n, 1);
            this.portOut(string2);
            Object object = this.sendOpTail(string, n3, n, n2);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp1(String string, int n, int n2, long l) throws IOException {
        try {
            int n3 = this.sendOpHeader(string, n, 1);
            this.portOut(l);
            Object object = this.sendOpTail(string, n3, n, n2);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp2(String string, int n, int n2, String string2, long l) throws IOException {
        try {
            int n3 = this.sendOpHeader(string, n, 2);
            this.portOut(string2);
            this.portOut(l);
            Object object = this.sendOpTail(string, n3, n, n2);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp2(String string, int n, int n2, String string2, Object object) throws IOException {
        try {
            int n3 = this.sendOpHeader(string, n, 2);
            this.portOut(string2);
            this.portOutUnwrapped(object);
            Object object2 = this.sendOpTail(string, n3, n, n2);
            return object2;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp1n(String string, int n, int n2, String string2, Object[] objectArray) throws IOException {
        try {
            int n3 = this.sendOpHeader(string, n, 1 + objectArray.length);
            this.portOut(string2);
            for (int i = 0; i < objectArray.length; ++i) {
                this.portOutUnwrapped(objectArray[i]);
            }
            Object object = this.sendOpTail(string, n3, n, n2);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp2n(String string, int n, int n2, String string2, long l, Object[] objectArray) throws IOException {
        try {
            int n3 = this.sendOpHeader(string, n, 2 + objectArray.length);
            this.portOut(string2);
            this.portOut(l);
            for (int i = 0; i < objectArray.length; ++i) {
                this.portOutUnwrapped(objectArray[i]);
            }
            Object object = this.sendOpTail(string, n3, n, n2);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp3n(String string, int n, int n2, String string2, long l, String string3, Object[] objectArray) throws IOException {
        try {
            int n3 = this.sendOpHeader(string, n, 3 + objectArray.length);
            this.portOut(string2);
            this.portOut(l);
            this.portOut(string3);
            for (int i = 0; i < objectArray.length; ++i) {
                this.portOutUnwrapped(objectArray[i]);
            }
            Object object = this.sendOpTail(string, n3, n, n2);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    synchronized int getOpIndex() {
        return ++opIndex;
    }

    int sendOpHeader(String string, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = this.getOpIndex();
        String string2 = this.grabSoftLock("sendOpHeader()");
        if (string2.length() > 0) {
            throw new IOException("sendOpHeader " + string + "cannot grab lock: " + string2);
        }
        switch (this.state) {
            case 0: {
                this.state = 1;
                n3 = this.portOutTag(206);
                if (n3 >= 0) {
                    n3 = this.portOut(string);
                }
                if (n3 < 0) {
                    return n3;
                }
                n3 = n < 0 ? this.portOut(0) : (n == 0 ? this.portOut(-n4) : this.portOut(n4));
                if (n3 < 0) break;
                n3 = this.portOut(n2);
                break;
            }
            case -1: {
                n3 = -101;
                break;
            }
            default: {
                n3 = -102;
            }
        }
        if (n3 < 0) {
            AGDirectLink.throwIOErr("sendOpHeader ", n3);
        }
        return n4;
    }

    Object sendOpTail(String string, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        n4 = this.streamOutFlush();
        if (n4 < 0) {
            AGDirectLink.throwIOErr("sendOp", n4);
        }
        if (n2 < 0) {
            return null;
        }
        this.state = 4;
        return this.opResIn(string, n, n3);
    }

    Object opResIn(String string, int n, int n2) throws IOException {
        Object[] objectArray = this.portInOp();
        if (2 > objectArray.length) {
            throw new IOException("opResIn " + string + "[" + n + "]" + " received " + objectArray.length);
        }
        if (!string.equals(objectArray[0])) {
            throw new IOException("opResIn " + string + "[" + n + "]" + " received " + objectArray[0]);
        }
        long l = (Long)objectArray[1];
        if (l < 0L && -l == (long)n && 3 < objectArray.length) {
            throw new IOException("opResIn " + string + "[" + n + "]" + " error in AllegroGraph server " + objectArray[2] + " " + objectArray[3]);
        }
        if (l < 0L) {
            throw new IOException("opResIn " + string + "[" + n + "]" + " error in AllegroGraph server " + l + " " + objectArray.length);
        }
        if (l != (long)n) {
            throw new IOException("opResIn " + string + "[" + n + "]" + " expected " + n + " received " + l);
        }
        if (n2 == -1) {
            return objectArray;
        }
        if (n2 == -2) {
            if (2 == objectArray.length) {
                return null;
            }
            throw new IOException("opResIn " + string + "[" + n + "]" + " expected zero values, received " + objectArray.length);
        }
        if (0 <= n2 && n2 < objectArray.length - 2) {
            return objectArray[n2 + 2];
        }
        throw new IOException("opResIn mismatch:" + string + "[" + n + "]" + " expected " + (n2 + 1) + " results, received " + (objectArray.length - 2));
    }

    int streamOutFlush() {
        return this.portFlush();
    }

    int streamInCode() throws IOException {
        if (this.haveCode == 1000000) {
            return this.portIn_8();
        }
        int n = this.haveCode;
        this.haveCode = 1000000;
        return n;
    }

    int streamInCode(int n) {
        if (this.haveCode == 1000000) {
            this.haveCode = n;
            return n;
        }
        return -104;
    }

    String tagToString(int n) {
        if (n < 128) {
            return "NOT_A_TAG";
        }
        if (n < 192) {
            return "INTEGER";
        }
        switch (n) {
            case 192: {
                return "NULL";
            }
            case 193: {
                return "BYTE";
            }
            case 194: {
                return "SHORT";
            }
            case 195: {
                return "INT";
            }
            case 196: {
                return "CHAR";
            }
            case 197: {
                return "FLOAT";
            }
            case 198: {
                return "DOUBLE";
            }
            case 200: {
                return "SEQ";
            }
            case 201: {
                return "SPARSE";
            }
            case 202: {
                return "OBJECT";
            }
            case 203: {
                return "BOOLEANtrue";
            }
            case 204: {
                return "BOOLEANfalse";
            }
            case 205: {
                return "OPENd";
            }
            case 206: {
                return "OP";
            }
            case 256: {
                return "TAG_END";
            }
        }
        return "TAG_STRING";
    }

    Object streamInValue() throws IOException {
        return this.streamInValue(this.streamInCode());
    }

    Object streamInValue(int n) throws IOException {
        Object object = null;
        if (n < 128) {
            throw new IOException("streamInValue tag " + n);
        }
        if (n < 192) {
            object = new Long(this.portInLong(n));
        } else {
            switch (n) {
                case 192: {
                    break;
                }
                case 193: {
                    object = new Byte((byte)this.portInLong());
                    break;
                }
                case 194: {
                    object = new Short((short)this.portInLong());
                    break;
                }
                case 195: {
                    object = new Integer((int)this.portInLong());
                    break;
                }
                case 196: {
                    StringBuffer stringBuffer = new StringBuffer(2);
                    stringBuffer.append((char)this.portInLong());
                    object = new Character(stringBuffer.charAt(0));
                    break;
                }
                case 197: {
                    object = new Float(this.portInFloat(n));
                    break;
                }
                case 198: {
                    object = new Double(this.portInDouble(n));
                    break;
                }
                case 200: {
                    object = this.portInSequence(n);
                    break;
                }
                case 201: {
                    object = this.portInSparse(n);
                    break;
                }
                case 202: {
                    object = this.portInObject(n);
                    break;
                }
                case 203: {
                    object = new Boolean(true);
                    break;
                }
                case 204: {
                    object = new Boolean(false);
                    break;
                }
                case 205: {
                    throw new IOException("streamInValue tag " + n);
                }
                case 206: {
                    object = this.portInOp(n);
                    break;
                }
                case 256: {
                    throw new IOException("streamInValue tag " + n);
                }
                case 211: {
                    object = this.portInUPI(n);
                    break;
                }
                case 210: {
                    object = this.portInBytes(n);
                    break;
                }
                default: {
                    object = this.portInString(n);
                }
            }
        }
        return object;
    }

    Object portInSequence() throws IOException {
        return this.portInSequence(this.streamInCode());
    }

    Object portInSequence(int n) throws IOException {
        int n2 = (int)this.portInLong();
        int n3 = this.portIn_8();
        return this.portInSeqBody(n, n2, n3);
    }

    boolean isIntTag(int n) {
        if (n < 128) {
            return false;
        }
        return n < 192;
    }

    int portInDupRep(int n, int n2, Object object, String string) throws IOException {
        if (n == 212) {
            int n3 = (int)this.portInLong();
            Array.set(object, n2, Array.get(object, n2 - n3));
            return n2 + 1;
        }
        if (n == 213) {
            int n4 = (int)this.portInLong();
            int n5 = (int)this.portInLong();
            Object object2 = Array.get(object, n2 - n4);
            for (int i = 0; i < n5; ++i) {
                Array.set(object, n2++, object2);
            }
            return n2;
        }
        throw new IOException(string + " subtag " + n);
    }

    Object portInSeqLong(int n) throws IOException {
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.portIn_8();
            if (this.isIntTag(n3)) {
                lArray[n2++] = this.portInLong(n3);
                continue;
            }
            n2 = this.portInDupRep(n3, n2, lArray, "portInSeqLong");
        }
        return lArray;
    }

    Object portInSeqByte(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.portIn_8();
            if (this.isIntTag(n3)) {
                byArray[n2++] = (byte)this.portInLong(n3);
                continue;
            }
            n2 = this.portInDupRep(n3, n2, byArray, "portInSeqByte");
        }
        return byArray;
    }

    Object portInSeqShort(int n) throws IOException {
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.portIn_8();
            if (this.isIntTag(n3)) {
                sArray[n2++] = (short)this.portInLong(n3);
                continue;
            }
            n2 = this.portInDupRep(n3, n2, sArray, "portInSeqShort");
        }
        return sArray;
    }

    Object portInSeqInt(int n) throws IOException {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.portIn_8();
            if (this.isIntTag(n3)) {
                nArray[n2++] = (int)this.portInLong(n3);
                continue;
            }
            n2 = this.portInDupRep(n3, n2, nArray, "portInSeqInt");
        }
        return nArray;
    }

    Object portInSeqFloat(int n) throws IOException {
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.portIn_8();
            if (n3 == 197) {
                fArray[n2++] = this.portInFloat(n3);
                continue;
            }
            n2 = this.portInDupRep(n3, n2, fArray, "portInSeqFloat");
        }
        return fArray;
    }

    Object portInSeqDouble(int n) throws IOException {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.portIn_8();
            if (n3 == 198) {
                dArray[n2++] = this.portInDouble(n3);
                continue;
            }
            n2 = this.portInDupRep(n3, n2, dArray, "portInSeqDouble");
        }
        return dArray;
    }

    Object portInSeqString(int n) throws IOException {
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.portIn_8();
            if (n3 == 212) {
                int n4 = (int)this.portInLong();
                stringArray[n2] = stringArray[n2 - n4];
                ++n2;
                continue;
            }
            if (n3 == 213) {
                int n5 = (int)this.portInLong();
                int n6 = (int)this.portInLong();
                String string = stringArray[n2 - n5];
                for (int i = 0; i < n6; ++i) {
                    stringArray[n2++] = string;
                }
                continue;
            }
            CharSequence charSequence = this.portInString(n3);
            stringArray[n2] = charSequence == null ? null : ((Object)charSequence).toString();
            ++n2;
        }
        return stringArray;
    }

    Object portInSeqObject(int n) throws IOException {
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = this.portIn_8();
            if (n4 == 212) {
                n3 = (int)this.portInLong();
                objectArray[n2] = objectArray[n2 - n3];
                ++n2;
                continue;
            }
            if (n4 == 213) {
                n3 = (int)this.portInLong();
                int n5 = (int)this.portInLong();
                Object object = objectArray[n2 - n3];
                for (int i = 0; i < n5; ++i) {
                    objectArray[n2++] = object;
                }
                continue;
            }
            objectArray[n2++] = this.streamInValue(n4);
        }
        return objectArray;
    }

    UPIImpl[] portInSeqUPI(int n) throws IOException {
        UPIImpl[] uPIImplArray = new UPIImpl[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = this.portIn_8();
            if (n4 == 212) {
                n3 = (int)this.portInLong();
                uPIImplArray[n2] = uPIImplArray[n2 - n3];
                ++n2;
                continue;
            }
            if (n4 == 213) {
                n3 = (int)this.portInLong();
                int n5 = (int)this.portInLong();
                UPIImpl uPIImpl = uPIImplArray[n2 - n3];
                for (int i = 0; i < n5; ++i) {
                    uPIImplArray[n2++] = uPIImpl;
                }
                continue;
            }
            if (n4 == 192) {
                uPIImplArray[n2++] = null;
                continue;
            }
            if (n4 == 211) {
                uPIImplArray[n2++] = this.portInUPI(n4);
                continue;
            }
            uPIImplArray[n2++] = new UPIImpl(this.portInLong(n4));
        }
        return uPIImplArray;
    }

    Object portInSeqBody(int n, int n2, int n3) throws IOException {
        if (n != 200) {
            throw new IOException("portInSequence tag " + n);
        }
        if (n3 < 128) {
            throw new IOException("portInSequence subtag " + n3);
        }
        if (n3 < 192) {
            return this.portInSeqLong(n2);
        }
        if (n3 < 222) {
            switch (n3) {
                case 193: {
                    return this.portInSeqByte(n2);
                }
                case 211: {
                    return this.portInSeqUPI(n2);
                }
                case 194: {
                    return this.portInSeqShort(n2);
                }
                case 195: {
                    return this.portInSeqInt(n2);
                }
                case 128: {
                    return this.portInSeqLong(n2);
                }
                case 196: {
                    char[] cArray = new char[n2];
                    for (int i = 0; i < n2; ++i) {
                        cArray[i] = (char)this.portInLong();
                    }
                    return cArray;
                }
                case 197: {
                    return this.portInSeqFloat(n2);
                }
                case 198: {
                    return this.portInSeqDouble(n2);
                }
                case 203: 
                case 204: {
                    boolean[] blArray = new boolean[n2];
                    block16: for (int i = 0; i < n2; ++i) {
                        int n4 = this.portIn_8();
                        switch (n4) {
                            case 203: {
                                blArray[i] = true;
                                continue block16;
                            }
                            case 204: {
                                blArray[i] = false;
                                continue block16;
                            }
                            default: {
                                throw new IOException("portInSequence boolean " + n4);
                            }
                        }
                    }
                    return blArray;
                }
            }
            return this.portInSeqObject(n2);
        }
        return this.portInSeqString(n2);
    }

    Object portInSparse(int n) throws IOException {
        throw new IOException("portInSparse not implemented " + n);
    }

    Object portInObject(int n) throws IOException {
        throw new IOException("portInObject not implemented" + n);
    }

    Object[] portInOp() throws IOException {
        return this.portInOp(this.streamInCode());
    }

    static String stringValue(Object object) {
        if (object == null) {
            return "Null";
        }
        return object.toString();
    }

    Object[] portInOp(int n) throws IOException {
        if (n != 206) {
            throw new IOException("portInOp tag " + n);
        }
        CharSequence charSequence = this.portInString();
        long l = this.portInLong();
        int n2 = (int)this.portInLong();
        Object[] objectArray = new Object[n2 + 2];
        objectArray[0] = charSequence;
        objectArray[1] = new Long(l);
        for (int i = 0; i < n2; ++i) {
            objectArray[i + 2] = this.streamInValue();
        }
        String string = "Unknown";
        String string2 = "Unknown";
        if (n2 > 0) {
            string = AGDirectLink.stringValue(objectArray[2]);
        }
        if (n2 > 1) {
            string2 = AGDirectLink.stringValue(objectArray[3]);
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Operation " + charSequence + "[" + -l + "] signalled an error in server: " + string + " -- " + string2);
        }
        return objectArray;
    }

    Object[] portInOpOb(int n) throws IOException {
        if (n != 206) {
            throw new IOException("portInOp tag " + n);
        }
        CharSequence charSequence = this.portInString();
        long l = this.portInLong();
        int n2 = (int)this.portInLong();
        Object[] objectArray = new Object[n2];
        Object[] objectArray2 = new Object[]{charSequence, new Long(l), objectArray};
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.streamInValue();
        }
        if (l < 0L) {
            String string = "Unknown";
            String string2 = "Unknown";
            if (n2 > 0) {
                string = AGDirectLink.stringValue(objectArray[0]);
            }
            if (n2 > 1) {
                string2 = AGDirectLink.stringValue(objectArray[1]);
            }
            throw new IllegalArgumentException("Operation " + charSequence + "[" + -l + "] signalled an error in server: " + string + " -- " + string2);
        }
        return objectArray2;
    }

    int portIn_8() throws IOException {
        int n;
        try {
            n = this.inStream.read();
        }
        catch (IOException iOException) {
            n = -107;
        }
        if (n < 0) {
            AGDirectLink.throwIOErr("portIn", n);
        }
        return n;
    }

    byte[] portInBytes() throws IOException {
        return this.portInBytes(this.streamInCode());
    }

    byte[] portInBytes(int n) throws IOException {
        if (n != 210) {
            throw new IOException("portInOp tag " + n);
        }
        byte[] byArray = new byte[(int)this.portInLong()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(0xFF & this.portIn_8());
        }
        return byArray;
    }

    UPIImpl portInUPI() throws IOException {
        return this.portInUPI(this.streamInCode());
    }

    UPIImpl portInUPI(int n) throws IOException {
        if (n != 211) {
            throw new IOException("portInOp tag " + n);
        }
        UPIImpl uPIImpl = new UPIImpl();
        for (int i = 0; i < 12; ++i) {
            uPIImpl.addByte(this.portIn_8());
        }
        return uPIImpl;
    }

    int portOutInteger(long l) {
        int n;
        int n2;
        int n3;
        long l2 = l;
        int n4 = 0;
        if (l2 < 0L) {
            l2 = -(1L + l2);
            n4 = 32;
        }
        if (l2 < 23L) {
            n3 = -1;
            n2 = 0;
            n = 1;
        } else if (l2 < 279L) {
            n3 = 0;
            n2 = 8;
            n = 2;
            l2 -= 23L;
        } else if (l2 < 65536L) {
            n3 = 1;
            n2 = 16;
            n = 3;
        } else if (l2 < 0x1000000L) {
            n3 = 2;
            n2 = 24;
            n = 4;
        } else if (l2 < 0x100000000L) {
            n3 = 3;
            n2 = 32;
            n = 5;
        } else if (l2 < 0x10000000000L) {
            n3 = 4;
            n2 = 40;
            n = 6;
        } else if (l2 < 0x1000000000000L) {
            n3 = 5;
            n2 = 48;
            n = 7;
        } else if (l2 < 0x100000000000000L) {
            n3 = 6;
            n2 = 56;
            n = 8;
        } else {
            n3 = 7;
            n2 = 64;
            n = 9;
        }
        int n5 = this.portReserveSpace(n);
        if (n5 < 0) {
            return n5;
        }
        n3 = n3 < 0 ? (int)l2 : 23 + n3;
        n3 = n3 | n4 | 0x80;
        this.bufferOut_8(n3);
        for (int i = 0; i < n2; i += 8) {
            this.bufferOut_8((int)(0xFFL & l2 >> i));
        }
        return this.endpos;
    }

    long portInLong() throws IOException {
        return this.portInLong(this.portIn_8());
    }

    long portInLong(int n) throws IOException {
        if (n < 128 || n >= 192) {
            throw new IOException("portInLong tag " + n);
        }
        int n2 = n & 0x3F;
        int n3 = 0;
        boolean bl = false;
        if (n2 < 23) {
            return n2;
        }
        if (n2 > 31) {
            bl = true;
            if ((n2 -= 32) < 23) {
                return -n2 - 1;
            }
        }
        n3 = n2 - 23 + 1;
        long l = 0L;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            long l2 = this.portIn_8();
            if (l2 < 0L) {
                throw new IOException("portInLong->portIn_8=" + l2);
            }
            l |= l2 << n4;
            n4 += 8;
        }
        if (n3 == 1) {
            l += 23L;
        }
        if (bl) {
            l = -l - 1L;
        }
        return l;
    }

    CharSequence portInString() throws IOException {
        return this.portInString(this.portIn_8());
    }

    CharSequence portInString(int n) throws IOException {
        int n2;
        if (n == 192) {
            return null;
        }
        if (n < 222) {
            throw new IOException("portInString tag " + n);
        }
        if (n == 222) {
            n2 = (int)this.portInLong();
        } else if (n >= 224 && n < 256) {
            n2 = n - 224;
        } else {
            throw new IOException("portInString tag " + n);
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        char c = '\u0000';
        for (int i = 0; i < n2; ++i) {
            if (n3 == 0) {
                int n4 = this.streamInCode();
                if (n4 == 223) {
                    n3 = (int)this.portInLong();
                    c = (char)this.portInLong();
                    stringBuffer.append(c);
                    --n3;
                    continue;
                }
                stringBuffer.append((char)this.portInLong(n4));
                continue;
            }
            stringBuffer.append(c);
            --n3;
        }
        return new String(stringBuffer);
    }

    double portInDouble() throws IOException {
        return this.portInDouble(this.streamInCode());
    }

    double portInDouble(int n) throws IOException {
        if (n != 198) {
            throw new IOException("portInDouble tag " + n);
        }
        int n2 = this.portIn_8();
        if (n2 < 0) {
            throw new IOException("portInDouble->portIn_8=" + n2);
        }
        long l = this.portIn_8();
        if (l < 0L) {
            throw new IOException("portInDouble->portIn_8=" + l);
        }
        long l2 = this.portIn_8();
        if (l2 < 0L) {
            throw new IOException("portInDouble->portIn_8=" + l2);
        }
        long l3 = 0L;
        for (int i = 0; i < 51; i += 8) {
            long l4 = this.portIn_8();
            if (l4 < 0L) {
                throw new IOException("portInDouble->portIn_8=" + l4);
            }
            l3 |= l4 << i;
        }
        l3 |= (l2 << 8 | l) << 52;
        if (n2 != 0) {
            l3 |= Long.MIN_VALUE;
        }
        double d = Double.longBitsToDouble(l3);
        return d;
    }

    float portInFloat() throws IOException {
        return this.portInFloat(this.streamInCode());
    }

    float portInFloat(int n) throws IOException {
        if (n != 197) {
            throw new IOException("portInFloat tag " + n);
        }
        int n2 = this.portIn_8();
        if (n2 < 0) {
            throw new IOException("portInFloat->portIn_8=" + n2);
        }
        int n3 = this.portIn_8();
        if (n3 < 0) {
            throw new IOException("portInFloat->portIn_8=" + n3);
        }
        int n4 = this.portIn_8();
        if (n4 < 0) {
            throw new IOException("portInFloat->portIn_8=" + n4);
        }
        int n5 = 0;
        for (int i = 0; i < 23; i += 8) {
            int n6 = this.portIn_8();
            if (n6 < 0) {
                throw new IOException("portInFloat->portIn_8=" + n6);
            }
            n5 |= n6 << i;
        }
        n5 |= (n4 << 8 | n3) << 23;
        if (n2 != 0) {
            n5 |= Integer.MIN_VALUE;
        }
        float f = Float.intBitsToFloat(n5);
        return f;
    }

    int portFlush() {
        if (this.endpos > 0) {
            try {
                this.outStream.write(this.buffer, 0, this.endpos);
                this.outStream.flush();
            }
            catch (Exception exception) {
                return -108;
            }
        }
        this.endpos = 0;
        return 0;
    }

    int portReserveSpace(int n) {
        int n2 = 0;
        if (this.endpos + n > this.buffer.length) {
            n2 = this.portFlush();
        }
        if (n2 < 0) {
            return n2;
        }
        return this.endpos + n;
    }

    int portOutTag(int n) {
        int n2 = this.portReserveSpace(1);
        if (n2 < 0) {
            return n2;
        }
        n2 = this.bufferOut_8(n);
        return n2;
    }

    int portOut(int n, long l) {
        int n2 = 0;
        if (0 < n) {
            n2 = this.portOutTag(n);
        }
        if (n2 >= 0) {
            n2 = this.portOutInteger(l);
        }
        return n2;
    }

    int portOut(boolean bl) {
        if (bl) {
            return this.portOutTag(203);
        }
        return this.portOutTag(204);
    }

    int portOut(byte by) {
        return this.portOut(193, by);
    }

    int portOut(char c) {
        return this.portOut(196, c);
    }

    int portOut(short s) {
        return this.portOut(194, s);
    }

    int portOut(int n) {
        return this.portOut(195, n);
    }

    int portOut(long l) {
        return this.portOut(0, l);
    }

    int portOutSeqHead(String string, int n, int n2) {
        int n3;
        if (string == "") {
            string = "";
        }
        if ((n3 = this.portReserveSpace(1)) < 0) {
            return n3;
        }
        this.bufferOut_8(200);
        n3 = this.portOutInteger(n);
        if (n3 < 0) {
            return n3;
        }
        n3 = this.portReserveSpace(1);
        if (n3 < 0) {
            return n3;
        }
        this.bufferOut_8(n2);
        return this.endpos;
    }

    int portOut(byte[] byArray) {
        int n = this.portReserveSpace(1);
        if (n < 0) {
            return n;
        }
        this.bufferOut_8(210);
        n = this.portOutInteger(byArray.length);
        if (n < 0) {
            return n;
        }
        for (int i = 0; i < byArray.length; ++i) {
            n = this.portReserveSpace(1);
            if (n < 0) {
                return n;
            }
            this.bufferOut_8(byArray[i]);
        }
        return this.endpos;
    }

    int portOut(UPI uPI) {
        return this.portOut((UPIImpl)uPI);
    }

    int portOut(UPIImpl uPIImpl) {
        if (null == uPIImpl.getUpi()) {
            return this.portOut(uPIImpl.getCode());
        }
        int n = this.portReserveSpace(1);
        if (n < 0) {
            return n;
        }
        this.bufferOut_8(211);
        int n2 = 0;
        int n3 = 0;
        while (n2 > -1) {
            if ((n2 = uPIImpl.getByte(n3++)) <= -1) continue;
            n = this.portReserveSpace(1);
            if (n < 0) {
                return n;
            }
            this.bufferOut_8(n2);
        }
        return this.endpos;
    }

    int portOut(UPI[] uPIArray) {
        this.portOutSeqHead("UPI", uPIArray.length, 211);
        for (int i = 0; i < uPIArray.length; ++i) {
            this.portOut(uPIArray[i]);
        }
        return this.endpos;
    }

    int portOut(short[] sArray) {
        this.portOutSeqHead("short", sArray.length, 194);
        for (int i = 0; i < sArray.length; ++i) {
            this.portOutInteger(sArray[i]);
        }
        return this.endpos;
    }

    int portOut(int[] nArray) {
        this.portOutSeqHead("int", nArray.length, 195);
        for (int i = 0; i < nArray.length; ++i) {
            this.portOutInteger(nArray[i]);
        }
        return this.endpos;
    }

    int portOut(long[] lArray) {
        this.portOutSeqHead("long", lArray.length, 128);
        for (int i = 0; i < lArray.length; ++i) {
            this.portOutInteger(lArray[i]);
        }
        return this.endpos;
    }

    int portOut(float[] fArray) {
        this.portOutSeqHead("float", fArray.length, 197);
        for (int i = 0; i < fArray.length; ++i) {
            this.portOut(fArray[i]);
        }
        return this.endpos;
    }

    int portOut(double[] dArray) {
        this.portOutSeqHead("double", dArray.length, 198);
        for (int i = 0; i < dArray.length; ++i) {
            this.portOut(dArray[i]);
        }
        return this.endpos;
    }

    int portOut(CharSequence[] charSequenceArray) {
        this.portOutSeqHead("String", charSequenceArray.length, 222);
        for (int i = 0; i < charSequenceArray.length; ++i) {
            this.portOut(charSequenceArray[i]);
        }
        return this.endpos;
    }

    int portOut(float f) {
        int n = this.portReserveSpace(7);
        if (n < 0) {
            return n;
        }
        int n2 = Float.floatToRawIntBits(f);
        int n3 = 0;
        if (n2 < 0) {
            n2 ^= Integer.MIN_VALUE;
            n3 = 1;
        }
        int n4 = n2 >> 23;
        n2 |= 0x7F800000;
        n2 ^= 0x7F800000;
        this.bufferOut_8(197);
        this.bufferOut_8(n3);
        this.bufferOut_16(n4);
        for (int i = 0; i < 23; i += 8) {
            this.bufferOut_8((int)(0xFFL & (long)(n2 >> i)));
        }
        return this.endpos;
    }

    int portOut(double d) {
        int n = this.portReserveSpace(11);
        if (n < 0) {
            return n;
        }
        long l = Double.doubleToRawLongBits(d);
        int n2 = 0;
        if (l < 0L) {
            l ^= Long.MIN_VALUE;
            n2 = 1;
        }
        int n3 = (int)(l >> 52);
        l |= 0x7FF0000000000000L;
        l ^= 0x7FF0000000000000L;
        this.bufferOut_8(198);
        this.bufferOut_8(n2);
        this.bufferOut_16(n3);
        for (int i = 0; i < 52; i += 8) {
            this.bufferOut_8((int)(0xFFL & l >> i));
        }
        return this.endpos;
    }

    int portOut(CharSequence charSequence) {
        int n;
        if (charSequence == null) {
            return this.portOutNull();
        }
        int n2 = charSequence.length();
        if (n2 < 32) {
            n = this.portReserveSpace(1);
            if (n < 0) {
                return n;
            }
            this.bufferOut_8(224 + n2);
            for (int i = 0; i < n2; ++i) {
                this.portOutInteger(charSequence.charAt(i));
            }
        } else {
            n = this.portReserveSpace(1);
            if (n < 0) {
                return n;
            }
            this.bufferOut_8(222);
            n = this.portOutInteger(n2);
            if (n < 0) {
                return n;
            }
            int n3 = 0;
            char c = '\u0000';
            for (int i = 0; i < n2; ++i) {
                char c2 = charSequence.charAt(i);
                if (n3 == 0) {
                    n3 = 1;
                    c = c2;
                    continue;
                }
                if (c == c2) {
                    ++n3;
                    continue;
                }
                n = this.portOutFragment(n3, c);
                if (n < 0) {
                    return n;
                }
                n3 = 1;
                c = c2;
            }
            n = this.portOutFragment(n3, c);
        }
        return n;
    }

    int portOutFragment(int n, int n2) {
        int n3 = this.endpos;
        if (n < 5) {
            for (int i = 0; i < n; ++i) {
                n3 = this.portOutInteger(n2);
                if (n3 >= 0) continue;
                return n3;
            }
        } else {
            n3 = this.portReserveSpace(1);
            if (n3 >= 0) {
                this.bufferOut_8(223);
            }
            if (n3 >= 0) {
                n3 = this.portOutInteger(n);
            }
            if (n3 >= 0) {
                n3 = this.portOutInteger(n2);
            }
        }
        return n3;
    }

    int portOutNull() {
        return this.portOutTag(192);
    }

    int portOutUnwrapped(Object object) throws IOException {
        if (object == null) {
            return this.portOutNull();
        }
        if (object instanceof Boolean) {
            return this.portOut((Boolean)object);
        }
        if (object instanceof Byte) {
            return this.portOut((Byte)object);
        }
        if (object instanceof Short) {
            return this.portOut((Short)object);
        }
        if (object instanceof Integer) {
            return this.portOut((Integer)object);
        }
        if (object instanceof Long) {
            return this.portOut((Long)object);
        }
        if (object instanceof Float) {
            return this.portOut(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.portOut((Double)object);
        }
        if (object instanceof byte[]) {
            return this.portOut((byte[])object);
        }
        if (object instanceof UPIImpl) {
            return this.portOut((UPIImpl)object);
        }
        if (object instanceof UPI[]) {
            return this.portOut((UPI[])object);
        }
        if (object instanceof short[]) {
            return this.portOut((short[])object);
        }
        if (object instanceof int[]) {
            return this.portOut((int[])object);
        }
        if (object instanceof long[]) {
            return this.portOut((long[])object);
        }
        if (object instanceof float[]) {
            return this.portOut((float[])object);
        }
        if (object instanceof double[]) {
            return this.portOut((double[])object);
        }
        if (object instanceof String) {
            return this.portOut((String)object);
        }
        if (object instanceof String[]) {
            return this.portOut((String[])object);
        }
        throw new IOException("Cannot unwrap " + object);
    }

    int bufferOut_8(int n) {
        this.buffer[this.endpos] = (byte)(0xFF & n);
        ++this.endpos;
        return this.endpos;
    }

    int bufferOut_16(int n) {
        this.buffer[this.endpos] = (byte)(0xFF & n);
        ++this.endpos;
        this.buffer[this.endpos] = (byte)(0xFF & n >> 8);
        ++this.endpos;
        return this.endpos;
    }

    static class Op {
        private String op;
        private long opix;
        private Object[] vals;

        String getOp() {
            return this.op;
        }

        long getOpix() {
            return this.opix;
        }

        Object[] getVals() {
            return this.vals;
        }

        Op(String string, long l, Object[] objectArray) {
            this.op = string;
            this.opix = l;
            this.vals = objectArray;
        }
    }
}

