/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.util;

import com.franz.ag.AllegroGraphException;
import com.franz.ag.UPI;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.transport.AGConnector;

public abstract class AGBase {
    public int selectLimit = 1000;
    public boolean sync = true;
    public int tsx = -1;
    public String storeName = null;
    public String storeDirectory = null;

    public abstract AGConnector verifyEnabled();

    public String getLangPart(UPI uPI) throws AllegroGraphException {
        if (!UPIImpl.canReference(uPI)) {
            throw new IllegalStateException("getLangPart " + uPI);
        }
        return this.verifyEnabled().getLangPart(this, uPI);
    }

    public String getTextPart(UPI uPI) throws AllegroGraphException {
        if (!UPIImpl.canReference(uPI)) {
            throw new IllegalStateException("getTextPart " + uPI);
        }
        return this.verifyEnabled().getTextPart(this, uPI);
    }

    public String getTypePart(UPI uPI) throws AllegroGraphException {
        if (!UPIImpl.canReference(uPI)) {
            throw new IllegalStateException("getTypePart " + uPI);
        }
        return this.verifyEnabled().getTypePart(this, uPI);
    }

    public String getText(UPI uPI, String string) {
        if (string != null) {
            return string;
        }
        if (!UPIImpl.canReference(uPI)) {
            throw new IllegalStateException("getText " + uPI);
        }
        try {
            return this.getTextPart(uPI);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new IllegalStateException("getText " + allegroGraphException);
        }
    }

    public static String refNtripleString(String string) {
        if (string == null) {
            return string;
        }
        if (0 == string.length()) {
            return string;
        }
        if (string.startsWith("<")) {
            if (string.endsWith(">")) {
                return string;
            }
        } else {
            if (string.startsWith("\"")) {
                return string;
            }
            if (string.startsWith("!")) {
                return string;
            }
        }
        throw new IllegalArgumentException("String does not seem to be in ntriples format: " + string);
    }

    protected static String refUPIToString(UPI uPI) {
        if (UPIImpl.isNullContext(uPI)) {
            return "" + ((UPIImpl)uPI).getCode();
        }
        if (UPIImpl.canReference(uPI)) {
            return "" + ((UPIImpl)uPI).asChars("%Z");
        }
        return "" + ((UPIImpl)uPI).getCode();
    }

    protected static void notValRef(Object object) {
        throw new IllegalArgumentException("Cannot convert to AG reference string " + object);
    }

    public static String refNodeToString(String string) {
        return "%N" + string;
    }

    protected static String refAnonToString(String string) {
        return "%B" + string;
    }

    protected static String refLitInternal(String string, String string2, CharSequence charSequence) {
        if (charSequence == null) {
            return string + string2;
        }
        String string3 = "";
        String string4 = "0123456789abcdefghijklmnopqrstABCDEFGHIJKLMNOPQRST";
        for (int i = string2.length(); i > 0; i /= 50) {
            int n = i % 50;
            string3 = string4.charAt(n) + string3;
        }
        if (0 == string3.length()) {
            string3 = "0";
        }
        return string + string3 + "X" + string2 + charSequence;
    }

    protected static String refLitToString(String string, UPI uPI) {
        return AGBase.refLitInternal("%U", string, ((UPIImpl)uPI).asChars());
    }

    public static String refLitToString(String string, String string2, String string3) {
        if (string3 == null) {
            if (string2 == null) {
                return AGBase.refLitInternal("%L", string, null);
            }
            if (0 == string2.length()) {
                return AGBase.refLitInternal("%L", string, null);
            }
            return AGBase.refLitInternal("%G", string2, string);
        }
        if (string2 != null && 0 != string2.length()) {
            throw new IllegalArgumentException("Cannot specify language tag and type URI on one literal: " + string + " " + string2 + " " + string3);
        }
        if (0 == string3.length()) {
            throw new IllegalArgumentException("Empty string is not a valid type URI: " + string);
        }
        return AGBase.refLitInternal("%T", string, string3);
    }

    protected static UPI validUPI(UPI uPI) {
        if (UPIImpl.canReference(uPI)) {
            return uPI;
        }
        throw new IllegalArgumentException("Id number may not be negative " + uPI);
    }

    protected static Object minMaxRef(Object object) {
        String string;
        if (object == null) {
            return null;
        }
        if (object instanceof String && ((string = (String)object).indexOf("m") == 0 || string.indexOf("M") == 0)) {
            if (!(string.indexOf("i") != 1 && string.indexOf("I") != 1 || string.indexOf("n") != 2 && string.indexOf("N") != 2)) {
                return "min";
            }
            if (!(string.indexOf("a") != 1 && string.indexOf("A") != 1 || string.indexOf("x") != 2 && string.indexOf("X") != 2)) {
                return "max";
            }
        }
        return null;
    }

    protected String[] validRefStrings(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = AGBase.refNtripleString(stringArray[i]);
        }
        return stringArray;
    }

    public String typeToString(int n) {
        switch (n) {
            case 1: {
                return "anon";
            }
            case 2: {
                return "node";
            }
            case 3: {
                return "literal";
            }
            case 4: {
                return "literal/lang";
            }
            case 5: {
                return "typed-literal";
            }
            case 6: {
                return "triple";
            }
            case 7: {
                return "default-graph";
            }
            case 8: {
                return "encoded-string";
            }
            case 9: {
                return "encoded-integer";
            }
            case 10: {
                return "encoded-float";
            }
            case 11: {
                return "encoded-triple-id";
            }
        }
        return "unknown";
    }

    public void discardCursors(Object[] objectArray) throws AllegroGraphException {
        this.verifyEnabled().discardCursors(this, objectArray);
    }

    public long twinqlCount(boolean bl, String string, String string2, int n, int n2, Object[] objectArray) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().twinqlSelect(this, string, string2, n, n2, -1, bl, objectArray);
        return AGConnector.longValue(objectArray2[0]);
    }
}

