/*
 * Decompiled with CFR 0.152.
 */
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import java.io.IOException;

public class AGExample {
    static int debug = 0;
    static boolean quiet = false;

    static String lit(String string) {
        return "\"" + string + "\"";
    }

    static String uri(String string) {
        return "<http://" + string + ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws AllegroGraphException, IOException {
        int n = 4567;
        String string = "localhost";
        String string2 = "*";
        String string3 = "tsx";
        String string4 = "";
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-p")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-h")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-d")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-n")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-t")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-w")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-z")) {
                debug = 1;
                continue;
            }
            if (stringArray[i].equals("-zz")) {
                debug = 2;
                continue;
            }
            if (stringArray[i].equals("-x")) {
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-q")) continue;
            quiet = true;
        }
        if (string2.equals("*")) {
            AGExample.pr("Database folder argument (-d) is required.");
            System.exit(1);
        }
        AGExample.prd("port=" + n + "  dbDir=" + string2 + "  dbName=" + string3);
        AllegroGraphConnection allegroGraphConnection = new AllegroGraphConnection();
        allegroGraphConnection.setPort(n);
        allegroGraphConnection.setHost(string);
        allegroGraphConnection.setDebug(debug);
        boolean bl2 = false;
        if (bl) {
            allegroGraphConnection.startServer();
            bl2 = true;
        }
        allegroGraphConnection.enable();
        AGExample.prd("Connected to " + allegroGraphConnection);
        try {
            int n3;
            AllegroGraph allegroGraph = allegroGraphConnection.renew(string3, string2);
            AGExample.pr("  numberOfTriples() = " + allegroGraph.numberOfTriples());
            allegroGraph.addStatement(AGExample.uri("sub1"), AGExample.uri("pred1"), AGExample.lit("obj1"));
            allegroGraph.addStatement(AGExample.uri("sub2"), AGExample.uri("pred2"), AGExample.lit("obj2"));
            AGExample.pr("  numberOfTriples() = " + allegroGraph.numberOfTriples());
            allegroGraph.addStatements(new String[]{AGExample.uri("sub3"), AGExample.uri("sub4"), AGExample.lit("sub5")}, new String[]{AGExample.uri("pred3"), AGExample.uri("pred4"), AGExample.lit("pred5")}, new String[]{AGExample.uri("obj3"), AGExample.uri("obj4"), AGExample.lit("obj5")});
            AGExample.pr("  numberOfTriples() = " + allegroGraph.numberOfTriples());
            allegroGraph.addStatements(new String[]{AGExample.uri("sub6")}, new String[]{AGExample.uri("pred3"), AGExample.uri("pred4"), AGExample.uri("pred5")}, new String[]{AGExample.lit("obj3"), AGExample.lit("obj4")});
            AGExample.pr("  numberOfTriples() = " + allegroGraph.numberOfTriples());
            allegroGraph.newTriple(AGExample.uri("sub7"), AGExample.uri("pred7"), AGExample.lit("obj7"));
            allegroGraph.newTriples(new String[]{AGExample.uri("sub7")}, new String[]{AGExample.uri("pred6")}, new String[]{AGExample.lit("obj3"), AGExample.lit("obj4"), AGExample.lit("obj5")});
            AGExample.pr("  numberOfTriples() = " + allegroGraph.numberOfTriples());
            TriplesIterator triplesIterator = allegroGraph.getStatements(AGExample.uri("sub7"), AGExample.uri("pred6"), null);
            AGExample.pr("atTriple=" + triplesIterator.atTriple() + "   nextP=" + triplesIterator.hasNext());
            AGExample.pr("toString: " + triplesIterator);
            if (triplesIterator.step()) {
                AGExample.pr("getTriple: " + triplesIterator.getTriple());
            }
            if (triplesIterator.step()) {
                AGExample.pr("getTriple: " + triplesIterator.getTriple());
            }
            if (triplesIterator.step()) {
                AGExample.pr("getTriple: " + triplesIterator.getTriple());
            }
            AGExample.pr("toString: " + triplesIterator);
            AGExample.pr("next of empty " + triplesIterator.step() + "  " + triplesIterator);
            triplesIterator = allegroGraph.getStatements(AGExample.uri("sub7"), AGExample.uri("pred6"), null);
            Triple[] tripleArray = triplesIterator.step(3);
            AGExample.pr("next(3) returns " + tripleArray.length);
            for (n3 = 0; n3 < tripleArray.length; ++n3) {
                AGExample.pr(n3 + " - " + tripleArray[n3]);
            }
            triplesIterator = allegroGraph.getStatements(AGExample.uri("sub7"), AGExample.uri("pred6"), null);
            tripleArray = triplesIterator.step(4);
            AGExample.pr("next(4) returns " + tripleArray.length);
            for (n3 = 0; n3 < tripleArray.length; ++n3) {
                AGExample.pr(n3 + " - " + tripleArray[n3]);
            }
            triplesIterator = allegroGraph.getStatements(null, null, AGExample.lit("obj4"));
            AGExample.pr("get(nil nil obj4) = " + triplesIterator);
            if (triplesIterator.step()) {
                AGExample.pr("S=" + triplesIterator.getS() + "  P=" + triplesIterator.getP() + "  O=" + triplesIterator.getO());
                AGExample.pr("id=" + triplesIterator.get_id() + "   " + triplesIterator);
                AGExample.pr("Literals: " + triplesIterator.getSubject() + "  " + triplesIterator.getPredicate() + "  " + triplesIterator.getObject());
                AGExample.pr("Triple: " + triplesIterator.getTriple());
            } else {
                AGExample.pr("NO NEXT: " + triplesIterator);
            }
            AGExample.pr("Before 10  numberOfTriples() = " + allegroGraph.numberOfTriples());
            for (n3 = 100; n3 < 110; ++n3) {
                allegroGraph.addStatement(AGExample.uri("sub" + n3), AGExample.uri("pred" + n3), AGExample.lit("obj" + n3));
            }
            AGExample.pr("After 10  numberOfTriples() = " + allegroGraph.numberOfTriples());
            String[] stringArray2 = new String[100];
            String[] stringArray3 = new String[100];
            String[] stringArray4 = new String[100];
            for (int i = 0; i < 100; ++i) {
                stringArray2[i] = AGExample.uri("suba" + i);
                stringArray3[i] = AGExample.uri("preda" + i);
                stringArray4[i] = AGExample.lit("obja" + i);
            }
            AGExample.pr("Before 100  numberOfTriples() = " + allegroGraph.numberOfTriples());
            allegroGraph.addStatements(stringArray2, stringArray3, stringArray4);
            AGExample.pr("After 100  numberOfTriples() = " + allegroGraph.numberOfTriples());
            Object var16_20 = null;
            triplesIterator = allegroGraph.getStatements(var16_20, null, null);
            int n4 = 0;
            Triple triple = null;
            while (triplesIterator.step()) {
                ++n4;
                if (!quiet) {
                    AGExample.pr("all " + n4 + " " + triplesIterator);
                }
                if (n4 != 7) continue;
                triple = triplesIterator.getTriple();
            }
            AGExample.pr("Query call returns null values for components.");
            AGExample.prq(triple);
            AGExample.pr("Get call returns actual values for components.");
            AGExample.prg(triple);
            AGExample.pr("After a get, query call returns actual values for components.");
            AGExample.prq(triple);
            if (n2 > 0) {
                try {
                    Thread.sleep(1000 * n2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            allegroGraph.closeTripleStore();
            if (!string4.equals("")) {
                allegroGraph = allegroGraphConnection.replace(string3, string2);
                AGExample.pr("  numberOfTriples() = " + allegroGraph.numberOfTriples());
                allegroGraph.loadNTriples(string4);
                AGExample.pr("  numberOfTriples() = " + allegroGraph.numberOfTriples());
                allegroGraph.indexAllTriples();
                Object var19_24 = null;
                triplesIterator = allegroGraph.getStatements(var19_24, null, null);
                n4 = 0;
                triple = null;
                while (triplesIterator.step() && n4 < 10) {
                    AGExample.pr("from ntriple file " + ++n4 + " " + triplesIterator);
                    AGExample.prg(triplesIterator.getTriple());
                }
                allegroGraph.closeTripleStore();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            AGExample.pr("ALL DONE.");
            allegroGraphConnection.disable();
            if (bl2) {
                allegroGraphConnection.stopServer();
            }
        }
    }

    static void pr(String string) {
        System.out.println(string);
    }

    static void pr(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    static void prd(String string) {
        if (debug > 0) {
            AGExample.pr(string);
        }
    }

    static void prq(Triple triple) {
        AGExample.pr("Triple " + triple);
        AGExample.pr("   triple subject:   " + triple.querySubject());
        AGExample.pr("   triple predicate: " + triple.queryPredicate());
        AGExample.pr("   triple object:    " + triple.queryObject());
    }

    static void prg(Triple triple) throws AllegroGraphException {
        AGExample.pr("Triple " + triple);
        AGExample.pr("   triple subject:   " + triple.getSubjectLabel());
        AGExample.pr("   triple predicate: " + triple.getPredicateLabel());
        AGExample.pr("   triple object:    " + triple.getObjectLabel());
    }
}

