/*
 * Decompiled with CFR 0.152.
 */
package com.franz.ag.repository;

import com.franz.agbase.ValueNode;
import com.franz.agbase.ValueObject;
import com.franz.agbase.ValueSetIterator;
import com.franz.agsail.util.AGSInternal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.BindingImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AGBindingSet
implements BindingSet {
    AGSInternal ags = null;
    ValueObject[] vals = null;
    Map<String, Integer> nameIndex = new HashMap<String, Integer>();

    AGBindingSet(AGSInternal aGSInternal, ValueSetIterator valueSetIterator) {
        this.ags = aGSInternal;
        String[] stringArray = valueSetIterator.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.nameIndex.put(stringArray[i], i);
        }
        this.vals = valueSetIterator.get();
    }

    public Binding getBinding(String string) {
        return new BindingImpl(string, this.getValue(string));
    }

    public Set<String> getBindingNames() {
        return this.nameIndex.keySet();
    }

    public Value getValue(String string) {
        return this.ags.coerceToSailValue((ValueNode)this.vals[this.nameIndex.get(string)]);
    }

    public boolean hasBinding(String string) {
        return this.nameIndex.containsKey(string);
    }

    public Iterator<Binding> iterator() {
        HashSet<BindingImpl> hashSet = new HashSet<BindingImpl>();
        Set<String> set = this.getBindingNames();
        for (String string : set) {
            Value value = this.getValue(string);
            if (value == null) continue;
            hashSet.add(new BindingImpl(string, value));
        }
        return hashSet.iterator();
    }

    public int size() {
        return this.nameIndex.size();
    }
}

