/*
 * Decompiled with CFR 0.152.
 */
package com.franz.ag.repository;

import com.franz.ag.repository.AGGraphQueryResult;
import com.franz.ag.repository.AGQuery;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.SPARQLQuery;
import com.franz.agbase.TriplesIterator;
import com.franz.agsail.AGSailCursor;
import com.franz.agsail.util.AGSInternal;
import org.openrdf.model.Statement;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class AGGraphQuery
extends AGQuery
implements GraphQuery {
    public AGGraphQuery(AGSInternal aGSInternal, SPARQLQuery sPARQLQuery) {
        super(aGSInternal, sPARQLQuery);
    }

    public GraphQueryResult evaluate() throws QueryEvaluationException {
        TriplesIterator triplesIterator;
        try {
            triplesIterator = this.sq.construct();
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new QueryEvaluationException((Throwable)allegroGraphException);
        }
        return new AGGraphQueryResult(this.ags.coerceToSailCursor(triplesIterator));
    }

    public void evaluate(RDFHandler rDFHandler) throws QueryEvaluationException, RDFHandlerException {
        try {
            TriplesIterator triplesIterator = this.sq.construct();
            rDFHandler.startRDF();
            AGSailCursor aGSailCursor = this.ags.coerceToSailCursor(triplesIterator);
            while (aGSailCursor.hasNext()) {
                rDFHandler.handleStatement((Statement)aGSailCursor.getNext());
            }
            rDFHandler.endRDF();
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new QueryEvaluationException((Throwable)allegroGraphException);
        }
    }
}

