/*
 * Decompiled with CFR 0.152.
 */
package com.franz.ag.repository;

import com.franz.ag.repository.AGRepositoryConnection;
import com.franz.agbase.AllegroGraph;
import com.franz.agsail.util.AGSInternal;
import com.knowledgereefsystems.agsail.AllegroSail;
import java.io.File;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.SailException;

public class AGRepository
implements Repository {
    AllegroGraph store = null;
    AGSInternal ags = null;
    AllegroSail sail = null;
    private AGRepositoryConnection repoConn = null;

    public static String version() {
        Class<AGRepository> clazz = AGRepository.class;
        Class<?>[] classArray = clazz.getDeclaredClasses();
        String string = clazz.getName();
        String string2 = "";
        string = string + "$V";
        for (int i = 0; i < classArray.length; ++i) {
            String string3 = classArray[i].getName();
            if (!string3.startsWith(string)) continue;
            string2 = string3;
        }
        return string2;
    }

    public AGRepository(AllegroGraph allegroGraph) {
        this.store = allegroGraph;
        this.sail = new AllegroSail(allegroGraph);
    }

    public void setReindexOnCommit(boolean bl) {
        this.sail.setReindexOnCommit(bl);
    }

    public void setIndexAllOnCommit(boolean bl) {
        this.sail.setIndexAllOnCommit(bl);
    }

    public void setBackgroundIndexing(boolean bl) {
        this.sail.setBackgroundIndexing(bl);
    }

    public AllegroGraph getAllegroGraph() {
        return this.store;
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (this.repoConn == null) {
            this.repoConn = new AGRepositoryConnection(this);
        }
        return this.repoConn;
    }

    public File getDataDir() {
        return this.sail.getDataDir();
    }

    public ValueFactory getValueFactory() {
        return this.sail.getValueFactory();
    }

    public void initialize() throws RepositoryException {
        try {
            this.sail.initialize();
            this.ags = this.sail.getAGSInternal();
        }
        catch (SailException sailException) {
            throw new RepositoryException(sailException.getLocalizedMessage());
        }
    }

    public boolean isWritable() throws RepositoryException {
        try {
            return this.sail.isWritable();
        }
        catch (SailException sailException) {
            throw new RepositoryException(sailException.getLocalizedMessage());
        }
    }

    public void setDataDir(File file) {
        this.sail.setDataDir(file);
    }

    public void shutDown() throws RepositoryException {
        try {
            if (this.repoConn != null) {
                this.repoConn.close();
                this.repoConn = null;
            }
            this.sail.shutDown();
            this.sail = null;
        }
        catch (SailException sailException) {
            throw new RepositoryException(sailException.getLocalizedMessage());
        }
    }

    public static class V3_2Jan27 {
    }
}

