/*
 * Decompiled with CFR 0.152.
 */
package com.franz.ag.repository;

import com.franz.ag.repository.AGBooleanQuery;
import com.franz.ag.repository.AGCloseableIteration;
import com.franz.ag.repository.AGGraphQuery;
import com.franz.ag.repository.AGRepository;
import com.franz.ag.repository.AGTupleQuery;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.SPARQLQuery;
import com.knowledgereefsystems.agsail.AllegroSail;
import com.knowledgereefsystems.agsail.AllegroSailConnection;
import info.aduna.iteration.Iteration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.openrdf.sail.SailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AGRepositoryConnection
implements RepositoryConnection {
    boolean isOpen = false;
    AGRepository repository = null;
    AllegroSail sail = null;
    AllegroSailConnection sailconn = null;
    int batchSize = 1000;

    AGRepositoryConnection(AGRepository aGRepository) throws RepositoryException {
        this.repository = aGRepository;
        this.sail = aGRepository.sail;
        try {
            this.sailconn = this.sail.getConnection();
            this.isOpen = true;
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public void add(Statement statement, Resource ... resourceArray) throws RepositoryException {
        this.add(statement.getSubject(), statement.getPredicate(), statement.getObject(), resourceArray);
    }

    public void add(Iterable<? extends Statement> iterable, Resource ... resourceArray) throws RepositoryException {
        try {
            Statement[] statementArray = new Statement[this.batchSize];
            Iterator<? extends Statement> iterator = iterable.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                statementArray[n] = iterator.next();
                if (this.batchSize != ++n && iterator.hasNext()) continue;
                Object[] objectArray = new Object[n];
                Object[] objectArray2 = new Object[n];
                Object[] objectArray3 = new Object[n];
                Object[] objectArray4 = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = this.repository.ags.coerceToAGPart(statementArray[i].getSubject());
                    objectArray2[i] = this.repository.ags.coerceToAGPart(statementArray[i].getPredicate());
                    objectArray3[i] = this.repository.ags.coerceToAGPart(statementArray[i].getObject());
                    objectArray4[i] = this.repository.ags.coerceToAGPart(statementArray[i].getContext());
                    if (resourceArray.length == 0) {
                        this.repository.store.addStatements(objectArray, objectArray2, objectArray3, objectArray4);
                    } else {
                        for (Resource resource : resourceArray) {
                            this.repository.store.addStatements(objectArray, objectArray2, objectArray3, this.repository.ags.coerceToAGPart(resource));
                        }
                    }
                    n = 0;
                    this.sailconn.setUncommittedInsertions(true);
                }
            }
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new RepositoryException((Throwable)allegroGraphException);
        }
    }

    public <E extends Exception> void add(Iteration<? extends Statement, E> iteration, Resource ... resourceArray) throws RepositoryException, E {
        try {
            Statement[] statementArray = new Statement[this.batchSize];
            int n = 0;
            while (iteration.hasNext()) {
                statementArray[n] = (Statement)iteration.next();
                if (this.batchSize != ++n && iteration.hasNext()) continue;
                Object[] objectArray = new Object[n];
                Object[] objectArray2 = new Object[n];
                Object[] objectArray3 = new Object[n];
                Object[] objectArray4 = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = this.repository.ags.coerceToAGPart(statementArray[i].getSubject());
                    objectArray2[i] = this.repository.ags.coerceToAGPart(statementArray[i].getPredicate());
                    objectArray3[i] = this.repository.ags.coerceToAGPart(statementArray[i].getObject());
                    objectArray4[i] = this.repository.ags.coerceToAGPart(statementArray[i].getContext());
                    if (resourceArray.length == 0) {
                        this.repository.store.addStatements(objectArray, objectArray2, objectArray3, objectArray4);
                    } else {
                        for (Resource resource : resourceArray) {
                            this.repository.store.addStatements(objectArray, objectArray2, objectArray3, this.repository.ags.coerceToAGPart(resource));
                        }
                    }
                    n = 0;
                    this.sailconn.setUncommittedInsertions(true);
                }
            }
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new RepositoryException((Throwable)allegroGraphException);
        }
    }

    public void add(InputStream inputStream, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, RepositoryException {
        this.add(new InputStreamReader(inputStream, "UTF-8"), string, rDFFormat, resourceArray);
    }

    public void add(Reader reader, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, RepositoryException {
        String string2;
        if (rDFFormat != RDFFormat.NTRIPLES && rDFFormat != RDFFormat.RDFXML) {
            throw new UnsupportedRDFormatException("Only RDFFormat.NTRIPLES and RDFFormat.RDFXML are supported)");
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
        }
        try {
            if (rDFFormat == RDFFormat.NTRIPLES) {
                if (0 == resourceArray.length) {
                    this.repository.store.parseNTriples(stringBuffer.toString());
                } else {
                    for (Resource resource : resourceArray) {
                        this.repository.store.parseNTriples(stringBuffer.toString(), this.repository.ags.coerceToAGPart(resource));
                    }
                }
            } else if (rDFFormat == RDFFormat.RDFXML) {
                if (0 == resourceArray.length) {
                    this.repository.store.parseRDFXML(stringBuffer.toString(), "", string);
                } else {
                    for (Resource resource : resourceArray) {
                        this.repository.store.parseRDFXML(stringBuffer.toString(), this.repository.ags.coerceToAGPart(resource), string);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RDFParseException((Throwable)illegalArgumentException);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new RepositoryException((Throwable)allegroGraphException);
        }
        this.sailconn.setUncommittedInsertions(true);
    }

    public void add(URL uRL, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, RepositoryException {
        if (rDFFormat != RDFFormat.NTRIPLES && rDFFormat != RDFFormat.RDFXML) {
            throw new UnsupportedRDFormatException("Only RDFFormat.NTRIPLES and RDFFormat.RDFXML are supported)");
        }
        String string2 = uRL.toString();
        try {
            if (rDFFormat == RDFFormat.NTRIPLES) {
                if (0 == resourceArray.length) {
                    this.repository.store.loadNTriples(string2);
                } else {
                    for (Resource resource : resourceArray) {
                        this.repository.store.loadNTriples(string2, this.repository.ags.coerceToAGPart(resource));
                    }
                }
            } else if (rDFFormat == RDFFormat.RDFXML) {
                if (0 == resourceArray.length) {
                    this.repository.store.loadRDFXML(string2, "", string);
                } else {
                    for (Resource resource : resourceArray) {
                        this.repository.store.loadRDFXML(string2, this.repository.ags.coerceToAGPart(resource), string);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RDFParseException((Throwable)illegalArgumentException);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new RepositoryException((Throwable)allegroGraphException);
        }
        this.sailconn.setUncommittedInsertions(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, RepositoryException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.add(fileInputStream, string, rDFFormat, resourceArray);
        }
        finally {
            fileInputStream.close();
        }
    }

    public void add(Resource resource, URI uRI, Value value, Resource ... resourceArray) throws RepositoryException {
        try {
            this.sailconn.addStatement(resource, uRI, value, resourceArray);
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public void clear(Resource ... resourceArray) throws RepositoryException {
        try {
            this.sailconn.clear(resourceArray);
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public void clearNamespaces() throws RepositoryException {
        try {
            this.sailconn.clearNamespaces();
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public void close() throws RepositoryException {
        try {
            this.sailconn.close();
            this.isOpen = false;
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public void commit() throws RepositoryException {
        try {
            this.sailconn.commit();
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public void export(RDFHandler rDFHandler, Resource ... resourceArray) throws RepositoryException, RDFHandlerException {
        this.exportStatements(null, null, null, false, rDFHandler, resourceArray);
    }

    public void exportStatements(Resource resource, URI uRI, Value value, boolean bl, RDFHandler rDFHandler, Resource ... resourceArray) throws RepositoryException, RDFHandlerException {
        RepositoryResult<Statement> repositoryResult = this.getStatements(resource, uRI, value, bl, resourceArray);
        rDFHandler.startRDF();
        while (repositoryResult.hasNext()) {
            rDFHandler.handleStatement((Statement)repositoryResult.next());
        }
        rDFHandler.endRDF();
    }

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        RepositoryResult repositoryResult;
        try {
            repositoryResult = new RepositoryResult(new AGCloseableIteration<Resource>((Iteration<? extends Resource, SailException>)this.sailconn.getContextIDs()));
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
        return repositoryResult;
    }

    public String getNamespace(String string) throws RepositoryException {
        String string2 = null;
        try {
            string2 = this.sailconn.getNamespace(string);
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
        return string2;
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        RepositoryResult repositoryResult;
        try {
            repositoryResult = new RepositoryResult(new AGCloseableIteration<Namespace>((Iteration<? extends Namespace, SailException>)this.sailconn.getNamespaces()));
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
        return repositoryResult;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public RepositoryResult<Statement> getStatements(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws RepositoryException {
        RepositoryResult repositoryResult;
        try {
            repositoryResult = new RepositoryResult(new AGCloseableIteration<Statement>((Iteration<? extends Statement, SailException>)this.sailconn.getStatements(resource, uRI, value, bl, resourceArray)));
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
        return repositoryResult;
    }

    public boolean hasStatement(Statement statement, boolean bl, Resource ... resourceArray) throws RepositoryException {
        return this.hasStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), bl, resourceArray);
    }

    public boolean hasStatement(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws RepositoryException {
        boolean bl2 = false;
        try {
            if (resourceArray.length == 0) {
                bl2 = this.repository.store.hasStatement(bl, this.repository.ags.coerceToAGPart(resource), this.repository.ags.coerceToAGPart(uRI), this.repository.ags.coerceToAGPart(value), null);
            } else {
                for (int i = 0; i < resourceArray.length && !bl2; ++i) {
                    bl2 = resourceArray[i] == null ? this.repository.store.hasStatement(bl, this.repository.ags.coerceToAGPart(resource), this.repository.ags.coerceToAGPart(uRI), this.repository.ags.coerceToAGPart(value)) : this.repository.store.hasStatement(bl, this.repository.ags.coerceToAGPart(resource), this.repository.ags.coerceToAGPart(uRI), this.repository.ags.coerceToAGPart(value), this.repository.ags.coerceToAGPart(resourceArray[i]));
                }
            }
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new RepositoryException((Throwable)allegroGraphException);
        }
        return bl2;
    }

    public boolean isAutoCommit() throws RepositoryException {
        return true;
    }

    public boolean isEmpty() throws RepositoryException {
        return this.size(new Resource[0]) == 0L;
    }

    public boolean isOpen() throws RepositoryException {
        return this.isOpen;
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage queryLanguage, String string) throws RepositoryException, MalformedQueryException {
        return this.prepareBooleanQuery(queryLanguage, string, null);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage queryLanguage, String string, String string2) throws RepositoryException, MalformedQueryException {
        if (queryLanguage != QueryLanguage.SPARQL) {
            throw new MalformedQueryException("Only SPARQL queries are supported.");
        }
        SPARQLQuery sPARQLQuery = new SPARQLQuery();
        sPARQLQuery.setTripleStore(this.repository.store);
        sPARQLQuery.setQuery(string);
        sPARQLQuery.setIncludeInferred(true);
        if (string2 != null) {
            sPARQLQuery.setDefaultBase(string2);
        }
        return new AGBooleanQuery(this.repository.ags, sPARQLQuery);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage queryLanguage, String string) throws RepositoryException, MalformedQueryException {
        return this.prepareGraphQuery(queryLanguage, string, null);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage queryLanguage, String string, String string2) throws RepositoryException, MalformedQueryException {
        if (queryLanguage != QueryLanguage.SPARQL) {
            throw new MalformedQueryException("Only SPARQL queries are supported.");
        }
        SPARQLQuery sPARQLQuery = new SPARQLQuery();
        sPARQLQuery.setTripleStore(this.repository.store);
        sPARQLQuery.setQuery(string);
        sPARQLQuery.setIncludeInferred(true);
        if (string2 != null) {
            sPARQLQuery.setDefaultBase(string2);
        }
        return new AGGraphQuery(this.repository.ags, sPARQLQuery);
    }

    public Query prepareQuery(QueryLanguage queryLanguage, String string) throws RepositoryException, MalformedQueryException {
        return this.prepareQuery(queryLanguage, string, null);
    }

    public Query prepareQuery(QueryLanguage queryLanguage, String string, String string2) throws RepositoryException, MalformedQueryException {
        return null;
    }

    public TupleQuery prepareTupleQuery(QueryLanguage queryLanguage, String string) throws RepositoryException, MalformedQueryException {
        return this.prepareTupleQuery(queryLanguage, string, null);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage queryLanguage, String string, String string2) throws RepositoryException, MalformedQueryException {
        if (queryLanguage != QueryLanguage.SPARQL) {
            throw new MalformedQueryException("Only SPARQL queries are supported.");
        }
        SPARQLQuery sPARQLQuery = new SPARQLQuery();
        sPARQLQuery.setTripleStore(this.repository.store);
        sPARQLQuery.setQuery(string);
        sPARQLQuery.setIncludeInferred(true);
        if (string2 != null) {
            sPARQLQuery.setDefaultBase(string2);
        }
        return new AGTupleQuery(this.repository.ags, sPARQLQuery);
    }

    public void remove(Statement statement, Resource ... resourceArray) throws RepositoryException {
        this.remove(statement.getSubject(), statement.getPredicate(), statement.getObject(), resourceArray);
    }

    public void remove(Iterable<? extends Statement> iterable, Resource ... resourceArray) throws RepositoryException {
        Iterator<? extends Statement> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next(), resourceArray);
        }
    }

    public <E extends Exception> void remove(Iteration<? extends Statement, E> iteration, Resource ... resourceArray) throws RepositoryException, E {
        while (iteration.hasNext()) {
            this.remove((Statement)iteration.next(), resourceArray);
        }
    }

    public void remove(Resource resource, URI uRI, Value value, Resource ... resourceArray) throws RepositoryException {
        try {
            this.sailconn.removeStatements(resource, uRI, value, resourceArray);
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public void removeNamespace(String string) throws RepositoryException {
        try {
            this.sailconn.removeNamespace(string);
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public void rollback() throws RepositoryException {
        try {
            this.sailconn.rollback();
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public void setAutoCommit(boolean bl) throws RepositoryException {
        if (!bl) {
            throw new RepositoryException((Throwable)new UnsupportedOperationException());
        }
    }

    public void setNamespace(String string, String string2) throws RepositoryException {
        try {
            this.sailconn.setNamespace(string, string2);
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public long size(Resource ... resourceArray) throws RepositoryException {
        try {
            return this.sailconn.size(resourceArray);
        }
        catch (SailException sailException) {
            throw new RepositoryException((Throwable)sailException);
        }
    }

    public ValueFactory getValueFactory() {
        return this.sail.getValueFactory();
    }
}

