/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.LiteralNode;
import com.franz.agbase.UPI;
import com.franz.agbase.URINode;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.impl.ValueNodeImpl;
import com.franz.agbase.util.AGBase;

public class LiteralNodeImpl
extends ValueNodeImpl
implements LiteralNode {
    private static final long serialVersionUID = -3106405889572308071L;
    private String label;
    public UPI typeId;
    public String type;
    public static final Lang LANG_KNOWN = Lang.KNOWN;
    public static final Lang LANG_NONE = Lang.NONE;
    private Lang langSlot = null;
    private String language;

    LiteralNodeImpl(AllegroGraph allegroGraph, UPI uPI, String string, UPI uPI2, String string2, Lang lang, String string3) {
        this.owner = allegroGraph;
        this.nodeUPI = uPI;
        this.label = string;
        this.type = string2;
        this.language = string3;
        this.typeId = uPI2;
        this.langSlot = lang;
    }

    public String queryLabel() {
        return this.label;
    }

    public String getLabel() {
        this.label = this.owner.getText(this.nodeUPI, this.label);
        return this.label;
    }

    public String queryType() {
        return this.type;
    }

    public URINode getDatatype() {
        String string = this.getType();
        if (string == null) {
            return null;
        }
        return this.owner.createURI(string);
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.typeId == null) {
            return null;
        }
        if (UPIImpl.canReference(this.typeId)) {
            this.type = this.owner.getText(this.typeId, null);
        } else {
            try {
                this.type = this.owner.getTypePart(this.nodeUPI);
                this.typeId = null;
            }
            catch (AllegroGraphException allegroGraphException) {
                // empty catch block
            }
        }
        return this.type;
    }

    public String queryLanguage() {
        return this.language;
    }

    public String getLanguage() {
        if (this.language != null) {
            return this.language;
        }
        if (LANG_KNOWN == this.langSlot) {
            return this.language;
        }
        if (LANG_NONE == this.langSlot) {
            return null;
        }
        try {
            this.language = this.owner.getLangPart(this.nodeUPI);
            this.langSlot = LANG_KNOWN;
        }
        catch (AllegroGraphException allegroGraphException) {
            // empty catch block
        }
        return this.language;
    }

    public String toString() {
        String string = "";
        string = this.typeId == null && this.type == null ? (this.langSlot == LANG_NONE ? "" : (this.langSlot == null ? "@?" : (this.langSlot != LANG_KNOWN ? "@<err>" : (this.language == null ? "" : "@" + this.language)))) : (this.type != null ? "^^" + this.type : (UPIImpl.canReference(this.typeId) ? "^^<" + this.typeId + ">" : "^^?"));
        return "\"" + this.label + "\"" + string + ">";
    }

    public boolean equals(Object object) {
        switch (this.sameAGId(object)) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        if (object instanceof LiteralNodeImpl) {
            return this.toString().equals(object.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void add() throws AllegroGraphException {
        if (this.canReference()) {
            return;
        }
        if (this.label == null) {
            throw new IllegalStateException("Cannot add Literal with null label.");
        }
        if (this.type != null) {
            this.nodeUPI = this.owner.verifyEnabled().newLiteral((AGBase)this.owner, this.label, this.type, null);
            return;
        }
        if (UPIImpl.canReference(this.typeId)) {
            this.nodeUPI = this.owner.verifyEnabled().newLiteral((AGBase)this.owner, this.label, this.typeId, null);
            return;
        }
        if (this.typeId != null) {
            throw new IllegalStateException("Cannot add Literal with unknown type.");
        }
        if (this.langSlot == LANG_KNOWN && this.language != null) {
            this.nodeUPI = this.owner.verifyEnabled().newLiteral((AGBase)this.owner, this.label, this.type, this.language);
            return;
        }
        if (this.langSlot == LANG_NONE) {
            this.nodeUPI = this.owner.verifyEnabled().newLiteral((AGBase)this.owner, this.label, this.type, this.language);
            return;
        }
        throw new IllegalStateException("Cannot add uninitialized Literal.");
    }

    public UPI getAGId() throws AllegroGraphException {
        UPI uPI = this.queryAGId();
        if (null != uPI) {
            return uPI;
        }
        this.add();
        return super.getAGId();
    }

    public static final class Lang {
        int tag;
        public static final Lang KNOWN = new Lang(1);
        public static final Lang NONE = new Lang(0);

        private Lang(int n) {
            this.tag = n;
        }
    }
}

