/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena.query;

import com.franz.agbase.ValueObject;
import com.franz.agjena.AllegroGraphGraph;
import com.franz.agjena.JenaToAGManager;
import com.franz.agjena.exceptions.NiceException;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import java.util.Arrays;
import java.util.Iterator;

public class AllegroGraphQuerySolution
implements QuerySolution {
    private String[] variables;
    private ValueObject[] values;
    private JenaToAGManager j2ag;
    private ModelCom model;

    protected AllegroGraphQuerySolution(String[] stringArray, ValueObject[] valueObjectArray, AllegroGraphGraph allegroGraphGraph, ModelCom modelCom) {
        this.variables = stringArray;
        this.values = valueObjectArray;
        this.model = modelCom;
        this.j2ag = allegroGraphGraph.getJ2AG();
    }

    public RDFNode get(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.variables.length; ++i) {
            if (!string.equals(this.variables[i])) continue;
            ValueObject valueObject = this.values[i];
            if (valueObject == null) {
                return null;
            }
            return this.j2ag.valueObjectToRDFNode(valueObject, this.model);
        }
        return null;
    }

    public RDFNode get(int n) {
        if (n < 0 || n >= this.values.length) {
            return null;
        }
        ValueObject valueObject = this.values[n];
        if (valueObject == null) {
            return null;
        }
        return this.j2ag.valueObjectToRDFNode(valueObject, this.model);
    }

    public Resource getResource(String string) {
        RDFNode rDFNode = this.get(string);
        if (rDFNode == null) {
            return null;
        }
        if (rDFNode instanceof Resource) {
            return (Resource)rDFNode;
        }
        throw new NiceException("Value for variable " + string + " is not a resource " + rDFNode);
    }

    public Literal getLiteral(String string) {
        RDFNode rDFNode = this.get(string);
        if (rDFNode == null) {
            return null;
        }
        if (rDFNode instanceof Literal) {
            return (Literal)rDFNode;
        }
        throw new NiceException("Value for variable " + string + " is not a literal " + rDFNode);
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : this.variables) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public Iterator varNames() {
        return Arrays.asList(this.variables).iterator();
    }
}

