/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena.query;

import com.franz.agbase.ValueObject;
import com.franz.agbase.ValueSetIterator;
import com.franz.agjena.AllegroGraphGraph;
import com.franz.agjena.exceptions.NiceException;
import com.franz.agjena.exceptions.UnimplementedMethodException;
import com.franz.agjena.query.AllegroGraphBinding;
import com.franz.agjena.query.AllegroGraphQuerySolution;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.Arrays;
import java.util.List;

public class AllegroGraphResultSet
implements ResultSet {
    private AllegroGraphGraph graph;
    private String[] rowNames;
    private ValueSetIterator rows;
    private ModelCom model;
    private String queryString;
    int cursor = 0;

    public AllegroGraphResultSet(ValueSetIterator valueSetIterator, AllegroGraphGraph allegroGraphGraph, String string) {
        this.graph = allegroGraphGraph;
        this.rowNames = valueSetIterator.getNames();
        this.rows = valueSetIterator;
        this.queryString = string;
        this.model = new ModelCom((Graph)this.graph);
    }

    public boolean hasNext() {
        return this.rows.hasNext();
    }

    public Object next() {
        if (!this.rows.hasNext()) {
            throw new NiceException("Called 'next' with no remaining results.");
        }
        AllegroGraphQuerySolution allegroGraphQuerySolution = new AllegroGraphQuerySolution(this.rowNames, (ValueObject[])this.rows.next(), this.graph, this.model);
        ++this.cursor;
        return allegroGraphQuerySolution;
    }

    public QuerySolution nextSolution() {
        return (QuerySolution)this.next();
    }

    public Binding nextBinding() {
        if (!this.rows.hasNext()) {
            throw new NiceException("Called 'next' with no remaining results.");
        }
        AllegroGraphBinding allegroGraphBinding = new AllegroGraphBinding(this.rowNames, (ValueObject[])this.rows.next(), this.graph);
        ++this.cursor;
        return allegroGraphBinding;
    }

    public int getRowNumber() {
        return this.cursor;
    }

    public List getResultVars() {
        return Arrays.asList(this.rowNames);
    }

    public boolean isOrdered() {
        return this.queryString.toLowerCase().contains("order by");
    }

    public void remove() {
        throw new UnimplementedMethodException("remove");
    }

    public Model getResourceModel() {
        return null;
    }
}

