/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena.test;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agjena.AllegroGraphGraphMaker;
import com.franz.agjena.AllegroGraphModel;
import com.franz.agjena.StartUp;
import com.franz.agjena.query.AllegroGraphQuery;
import com.franz.agjena.query.AllegroGraphQueryExecutionFactory;
import com.franz.agjena.query.AllegroGraphQueryFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import java.io.IOException;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestARQueries
extends TestCase {
    static final String root = "doc-src/jena/ARQueries/";

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(TestARQueries.class);
        testSuite.setName("ARQuery-Scripts");
        return testSuite;
    }

    public TestARQueries(String string) {
        super(string);
    }

    public static void runTestScript(String string, String string2, String string3) {
        AllegroGraphQuery allegroGraphQuery = AllegroGraphQueryFactory.read(root + string);
        AllegroGraphModel allegroGraphModel = new AllegroGraphModel(AllegroGraphGraphMaker.getInstance().createGraph());
        FileManager.get().readModel((Model)allegroGraphModel, root + string2);
        QueryExecution queryExecution = AllegroGraphQueryExecutionFactory.create((Query)allegroGraphQuery, (Model)allegroGraphModel);
        ResultSetRewindable resultSetRewindable = ResultSetFactory.makeRewindable((ResultSet)queryExecution.execSelect());
        System.out.println("Testing query " + allegroGraphQuery.toString());
        System.out.println("== Result");
        ResultSetFormatter.out((ResultSet)resultSetRewindable);
        queryExecution.close();
    }

    public void test_arq_1() {
        TestARQueries.runTestScript("arq-q-1.rq", "data.ttl", "results-1.srj");
    }

    public void test_arq_2() {
        TestARQueries.runTestScript("arq-q-2.rq", "data.ttl", "results-2.srj");
    }

    public void test_arq_3() {
        TestARQueries.runTestScript("arq-q-3.rq", "data-1.ttl", "results-3.srj");
    }

    public void test_arq_4() {
        TestARQueries.runTestScript("arq-q-4.rq", "data-1.ttl", "results-4.srj");
    }

    public void test_arq_5() {
        TestARQueries.runTestScript("arq-q-5.rq", "data-1.ttl", "results-5.srj");
    }

    public void test_arq_6() {
        TestARQueries.runTestScript("arq-q-6.rq", "data-1.ttl", "results-6.srj");
    }

    public void test_arq_7() {
        TestARQueries.runTestScript("arq-q-7.rq", "data-1.ttl", "results-7.srj");
    }

    public void test_larq_1() {
        TestARQueries.runTestScript("larq-q-1.rq", "data.ttl", "results-1.srj");
    }

    private static Model resultSetToModel(ResultSet resultSet) {
        throw new RuntimeException("Need to call 'GraphUtils.makeDefaultModel()', which is not in the jar files.");
    }

    public static boolean resultSetEquivalent(Query query, ResultSet resultSet, ResultSet resultSet2) {
        Model model = TestARQueries.resultSetToModel(resultSet2);
        return TestARQueries.resultSetEquivalent(query, resultSet, model);
    }

    public static boolean resultSetEquivalent(Query query, ResultSet resultSet, Model model) {
        Model model2 = TestARQueries.resultSetToModel(resultSet);
        return model2.isIsomorphicWith(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws AllegroGraphException, IOException {
        AllegroGraph allegroGraph = StartUp.startUpTripleStore(StartUp.AccessTripleStore.RENEW, "localhost", "test", "/tmp/agtest", stringArray);
        AllegroGraphGraphMaker.setDefaultMaker(allegroGraph);
        if (allegroGraph != null) {
            try {
                System.out.println("About to try the ARQuery tests.");
                int n = 2;
                switch (n) {
                    case 1: {
                        new TestARQueries("ARQuery-Scripts").test_arq_1();
                        break;
                    }
                    case 2: {
                        new TestARQueries("ARQuery-Scripts").test_arq_2();
                        break;
                    }
                    case 8: {
                        new TestARQueries("ARQuery-Scripts").test_larq_1();
                    }
                }
                System.out.println("Finished ARQuery test " + n);
            }
            catch (Exception exception) {
                System.out.println("Failure in ARQuery test\n" + exception.toString() + exception.getMessage());
                exception.printStackTrace();
            }
            finally {
                StartUp.shutDownTripleStore(allegroGraph);
            }
        }
    }
}

