/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.knowledgereefsystems.agsail.AllegroSail;
import com.knowledgereefsystems.agsail.AllegroSailConnection;
import info.aduna.iteration.CloseableIteration;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AllegroSailTestCase
extends TestCase {
    protected AllegroSail sail;

    public void setUp() throws Exception {
        String string = "localhost";
        int n = 4567;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "test";
        File file = new File("/opt/allegro");
        this.sail = new AllegroSail(string, n, bl, string2, file, 0, 0, bl2, bl3);
        this.sail.initialize();
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        allegroSailConnection.removeStatements(null, null, null, new Resource[0]);
        allegroSailConnection.commit();
        allegroSailConnection.close();
    }

    public void tearDown() throws Exception {
        this.sail.shutDown();
    }

    public AllegroSailTestCase(String string) throws Exception {
        super(string);
    }

    protected void loadTrig(URL uRL) throws Exception {
        SailRepository sailRepository = new SailRepository((Sail)this.sail);
        RepositoryConnection repositoryConnection = sailRepository.getConnection();
        repositoryConnection.add(uRL, "", RDFFormat.TRIG, new Resource[0]);
        repositoryConnection.commit();
        repositoryConnection.close();
    }

    protected void loadTrig(File file) throws Exception {
        SailRepository sailRepository = new SailRepository((Sail)this.sail);
        RepositoryConnection repositoryConnection = sailRepository.getConnection();
        repositoryConnection.add(file, "", RDFFormat.TRIG, new Resource[0]);
        repositoryConnection.commit();
        repositoryConnection.close();
    }

    protected <T> Set<T> toSet(CloseableIteration<? extends T, SailException> closeableIteration) throws SailException {
        HashSet<Object> hashSet = new HashSet<Object>();
        while (closeableIteration.hasNext()) {
            hashSet.add(closeableIteration.next());
        }
        closeableIteration.close();
        return hashSet;
    }

    protected int count(CloseableIteration<?, SailException> closeableIteration) throws SailException {
        int n = 0;
        while (closeableIteration.hasNext()) {
            closeableIteration.next();
            ++n;
        }
        closeableIteration.close();
        return n;
    }
}

