/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.franz.agbase.AllegroGraphException;
import com.franz.agsail.AGSailCursor;
import com.knowledgereefsystems.agsail.AllegroSailException;
import info.aduna.iteration.CloseableIteration;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.SailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementIteration
implements CloseableIteration<Statement, SailException> {
    private AGSailCursor[] cursors;
    private int cursorIndex;
    private ValueFactory valueFactory;

    public StatementIteration(AGSailCursor[] aGSailCursorArray, ValueFactory valueFactory) {
        this.cursors = aGSailCursorArray;
        this.cursorIndex = 0;
        this.valueFactory = valueFactory;
    }

    public void close() throws SailException {
        try {
            for (int i = this.cursorIndex; i < this.cursors.length; ++i) {
                this.cursors[i].close();
            }
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
    }

    public boolean hasNext() throws SailException {
        if (this.cursorIndex >= this.cursors.length) {
            return false;
        }
        try {
            if (this.cursors[this.cursorIndex].hasNext()) {
                return true;
            }
            this.cursors[this.cursorIndex].close();
            ++this.cursorIndex;
            if (this.cursorIndex < this.cursors.length) {
                return this.cursors[this.cursorIndex].hasNext();
            }
            return false;
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
    }

    public Statement next() throws SailException {
        try {
            AGSailCursor aGSailCursor = this.cursors[this.cursorIndex];
            aGSailCursor.step();
            Statement statement = this.createStatement(aGSailCursor);
            return statement;
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
    }

    public void remove() throws SailException {
        try {
            this.cursors[this.cursorIndex].remove();
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
    }

    private Statement createStatement(AGSailCursor aGSailCursor) throws AllegroGraphException {
        Resource resource = aGSailCursor.getContext();
        return null == resource ? this.valueFactory.createStatement(aGSailCursor.getSubject(), aGSailCursor.getPredicate(), aGSailCursor.getObject()) : this.valueFactory.createStatement(aGSailCursor.getSubject(), aGSailCursor.getPredicate(), aGSailCursor.getObject(), resource);
    }
}

