/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.knowledgereefsystems.agsail.AllegroSailConnection;
import com.knowledgereefsystems.agsail.AllegroSailTestCase;
import java.io.File;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;

public class TestStatements
extends AllegroSailTestCase {
    public TestStatements(String string) throws Exception {
        super(string);
    }

    public void testAddStatement() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/ctxA");
        allegroSailConnection.removeStatements(null, null, null, new Resource[]{uRI});
        int n = this.count(allegroSailConnection.getStatements(null, null, null, false, new Resource[]{uRI}));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[]{uRI});
        int n2 = this.count(allegroSailConnection.getStatements(null, null, null, false, new Resource[]{uRI}));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, (Value)uRI, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, (Value)uRI, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, (Value)uRI, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[]{null});
        n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, (Value)uRI, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        Resource[] resourceArray = new Resource[]{uRI, null};
        allegroSailConnection.removeStatements((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, (Value)uRI, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, resourceArray);
        n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, (Value)uRI, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)2, (int)n2);
        allegroSailConnection.close();
    }

    public void testGetStatements() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/testGetStatements#a");
        boolean bl = false;
        allegroSailConnection.removeStatements(null, null, null, new Resource[0]);
        Resource[] resourceArray = new Resource[]{uRI, null};
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, resourceArray);
        int n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)2, (int)n);
        n = this.count(allegroSailConnection.getStatements(null, null, null, bl, new Resource[]{uRI}));
        TestStatements.assertEquals((int)1, (int)n);
        Resource[] resourceArray2 = new Resource[]{null};
        n = this.count(allegroSailConnection.getStatements(null, null, null, bl, resourceArray2));
        TestStatements.assertTrue((n > 0 ? 1 : 0) != 0);
        int n2 = n;
        n = this.count(allegroSailConnection.getStatements(null, null, null, bl, resourceArray));
        TestStatements.assertEquals((int)(1 + n2), (int)n);
        this.loadTrig(new File("resources/com/knowledgereefsystems/agsail/queryTest.trig"));
        URI uRI2 = this.sail.getValueFactory().createURI("http://knowledgereefsystems.com/agsail/test/instance1");
        n = this.count(allegroSailConnection.getStatements((Resource)uRI2, RDF.TYPE, null, false, new Resource[0]));
        TestStatements.assertEquals((int)1, (int)n);
        n = this.count(allegroSailConnection.getStatements((Resource)uRI2, RDF.TYPE, null, true, new Resource[0]));
        TestStatements.assertEquals((int)2, (int)n);
    }

    public void testGetStatementsWithVariableContexts() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/uriA");
        boolean bl = false;
        allegroSailConnection.removeStatements((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        allegroSailConnection.commit();
        Resource[] resourceArray = new Resource[]{uRI, null};
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, resourceArray);
        allegroSailConnection.commit();
        int n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)2, (int)n);
        n = this.count(allegroSailConnection.getStatements(null, null, null, bl, new Resource[]{uRI}));
        TestStatements.assertEquals((int)1, (int)n);
        Resource[] resourceArray2 = new Resource[]{null};
        n = this.count(allegroSailConnection.getStatements(null, null, null, bl, resourceArray2));
        TestStatements.assertTrue((n > 0 ? 1 : 0) != 0);
        int n2 = n;
        n = this.count(allegroSailConnection.getStatements(null, null, null, bl, resourceArray));
        TestStatements.assertEquals((int)(1 + n2), (int)n);
        allegroSailConnection.close();
    }

    public void testSize() throws Exception {
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/testSize#a");
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        allegroSailConnection.removeStatements(null, null, null, new Resource[]{uRI});
        TestStatements.assertEquals((long)0L, (long)allegroSailConnection.size(new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[]{uRI});
        allegroSailConnection.commit();
        TestStatements.assertEquals((long)1L, (long)allegroSailConnection.size(new Resource[0]));
        allegroSailConnection.removeStatements((Resource)uRI, uRI, (Value)uRI, new Resource[]{uRI});
        allegroSailConnection.commit();
        TestStatements.assertEquals((long)0L, (long)allegroSailConnection.size(new Resource[0]));
        allegroSailConnection.close();
    }

    public void testRemoveStatements() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/uriA");
        Resource[] resourceArray = new Resource[]{uRI, null};
        boolean bl = false;
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[0]);
        allegroSailConnection.commit();
        int n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, resourceArray);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)2, (int)n);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, resourceArray);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)2, (int)n);
        Resource[] resourceArray2 = new Resource[]{uRI};
        allegroSailConnection.removeStatements((Resource)uRI, null, null, resourceArray2);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)1, (int)n);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, resourceArray);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)2, (int)n);
        Resource[] resourceArray3 = new Resource[]{null};
        allegroSailConnection.removeStatements((Resource)uRI, null, null, resourceArray3);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)1, (int)n);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, resourceArray);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)2, (int)n);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, resourceArray));
        TestStatements.assertEquals((int)0, (int)n);
        allegroSailConnection.close();
    }

    public void testGetStatementsS_POG() throws Exception {
        boolean bl = false;
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/test/S_POG#a");
        URI uRI2 = this.sail.getValueFactory().createURI("http://example.org/test/S_POG#b");
        URI uRI3 = this.sail.getValueFactory().createURI("http://example.org/test/S_POG#c");
        URI uRI4 = this.sail.getValueFactory().createURI("http://example.org/test/S_POG#d");
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[0]);
        allegroSailConnection.commit();
        int n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI2, (Value)uRI3, new Resource[0]);
        allegroSailConnection.commit();
        int n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[]{uRI4});
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[]{uRI4}));
        allegroSailConnection.addStatement((Resource)uRI, uRI2, (Value)uRI3, new Resource[]{uRI4});
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[]{uRI4}));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[]{uRI});
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[]{uRI}));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[]{uRI});
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[]{uRI}));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, null, null, bl, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.close();
    }

    public void testGetStatementsSP_OG() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/test/SP_OG");
        int n = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, null, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        allegroSailConnection.commit();
        int n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, null, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.close();
    }

    public void testGetStatementsO_SPG() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/test/O_SPG");
        Literal literal = this.sail.getValueFactory().createLiteral("arbitrary plain literal 9548734867");
        Literal literal2 = this.sail.getValueFactory().createLiteral("arbitrary string literal 8765", XMLSchema.STRING);
        allegroSailConnection.removeStatements(null, null, (Value)uRI, new Resource[]{uRI});
        allegroSailConnection.commit();
        int n = this.count(allegroSailConnection.getStatements(null, null, (Value)uRI, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        allegroSailConnection.commit();
        int n2 = this.count(allegroSailConnection.getStatements(null, null, (Value)uRI, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements(null, null, (Value)literal, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements(null, null, (Value)literal, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)literal, new Resource[0]);
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements(null, null, (Value)literal, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements(null, null, (Value)literal, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements(null, null, (Value)literal2, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)literal2, new Resource[0]);
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements(null, null, (Value)literal2, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.close();
    }

    public void testGetStatementsPO_SG() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/test/PO_SG#a");
        URI uRI2 = this.sail.getValueFactory().createURI("http://example.org/test/PO_SG#b");
        URI uRI3 = this.sail.getValueFactory().createURI("http://knowledgereefsystems.com/thing/q");
        URI uRI4 = this.sail.getValueFactory().createURI("http://knowledgereefsystems.com/2007/11/core#firstName");
        Literal literal = this.sail.getValueFactory().createLiteral("arbitrary plain literal 8765675");
        Literal literal2 = this.sail.getValueFactory().createLiteral("Marko", XMLSchema.STRING);
        allegroSailConnection.removeStatements(null, null, null, new Resource[]{uRI});
        allegroSailConnection.commit();
        int n = this.count(allegroSailConnection.getStatements(null, uRI, (Value)uRI, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        allegroSailConnection.commit();
        int n2 = this.count(allegroSailConnection.getStatements(null, uRI, (Value)uRI, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements(null, null, (Value)literal, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements(null, uRI, (Value)literal, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)literal, new Resource[0]);
        allegroSailConnection.addStatement((Resource)uRI, uRI2, (Value)literal, new Resource[0]);
        allegroSailConnection.addStatement((Resource)uRI2, uRI2, (Value)literal, new Resource[0]);
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements(null, uRI, (Value)literal, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements(null, null, (Value)literal2, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements(null, uRI4, (Value)literal2, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI3, uRI4, (Value)literal2, new Resource[0]);
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements(null, uRI4, (Value)literal2, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        TestStatements.assertEquals((Object)uRI3, (Object)((Statement)this.toSet(allegroSailConnection.getStatements(null, uRI4, (Value)literal2, false, new Resource[0])).iterator().next()).getSubject());
        allegroSailConnection.close();
    }

    public void testGetStatementsSPO_G() throws Exception {
        boolean bl = false;
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/test/S_POG#a");
        URI uRI2 = this.sail.getValueFactory().createURI("http://example.org/test/S_POG#b");
        URI uRI3 = this.sail.getValueFactory().createURI("http://example.org/test/S_POG#c");
        URI uRI4 = this.sail.getValueFactory().createURI("http://example.org/test/S_POG#d");
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[0]);
        allegroSailConnection.commit();
        int n = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI2, (Value)uRI3, bl, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI2, (Value)uRI3, new Resource[0]);
        allegroSailConnection.commit();
        int n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI2, (Value)uRI3, bl, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, (Value)uRI, bl, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, (Value)uRI, bl, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[]{uRI4});
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI2, (Value)uRI3, bl, new Resource[]{uRI4}));
        allegroSailConnection.addStatement((Resource)uRI, uRI2, (Value)uRI3, new Resource[]{uRI4});
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI2, (Value)uRI3, bl, new Resource[]{uRI4}));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements((Resource)uRI, null, null, new Resource[]{uRI});
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, (Value)uRI, bl, new Resource[]{uRI}));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[]{uRI});
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements((Resource)uRI, uRI, (Value)uRI, bl, new Resource[]{uRI}));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.close();
    }

    public void testGetStatementsP_SOG() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/test/P_SOG#a");
        URI uRI2 = this.sail.getValueFactory().createURI("http://example.org/test/P_SOG#b");
        URI uRI3 = this.sail.getValueFactory().createURI("http://example.org/test/P_SOG#c");
        URI uRI4 = this.sail.getValueFactory().createURI("http://knowledgereefsystems.com/thing/q");
        URI uRI5 = this.sail.getValueFactory().createURI("http://knowledgereefsystems.com/2007/11/core#firstName");
        Literal literal = this.sail.getValueFactory().createLiteral("arbitrary plain literal 238445");
        Literal literal2 = this.sail.getValueFactory().createLiteral("Marko", XMLSchema.STRING);
        allegroSailConnection.removeStatements(null, uRI, null, new Resource[0]);
        allegroSailConnection.commit();
        int n = this.count(allegroSailConnection.getStatements(null, uRI, null, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[0]);
        allegroSailConnection.commit();
        int n2 = this.count(allegroSailConnection.getStatements(null, uRI, null, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements(null, uRI, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements(null, uRI, null, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)literal, new Resource[0]);
        allegroSailConnection.addStatement((Resource)uRI, uRI2, (Value)literal, new Resource[0]);
        allegroSailConnection.addStatement((Resource)uRI2, uRI2, (Value)literal, new Resource[0]);
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements(null, uRI, null, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements(null, uRI5, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements(null, uRI5, null, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI4, uRI5, (Value)literal2, new Resource[0]);
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements(null, uRI5, null, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        TestStatements.assertEquals((Object)uRI4, (Object)((Statement)this.toSet(allegroSailConnection.getStatements(null, uRI5, null, false, new Resource[0])).iterator().next()).getSubject());
        allegroSailConnection.removeStatements(null, uRI, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements(null, uRI, null, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[]{uRI});
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements(null, uRI, null, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)1, (int)n2);
        allegroSailConnection.removeStatements(null, uRI, null, new Resource[0]);
        allegroSailConnection.commit();
        n = this.count(allegroSailConnection.getStatements(null, uRI, null, false, new Resource[0]));
        allegroSailConnection.addStatement((Resource)uRI2, uRI, (Value)uRI3, new Resource[]{uRI3});
        allegroSailConnection.addStatement((Resource)uRI3, uRI, (Value)uRI, new Resource[]{uRI});
        allegroSailConnection.commit();
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI2, new Resource[]{uRI2});
        allegroSailConnection.commit();
        n2 = this.count(allegroSailConnection.getStatements(null, uRI, null, false, new Resource[0]));
        TestStatements.assertEquals((int)0, (int)n);
        TestStatements.assertEquals((int)3, (int)n2);
        allegroSailConnection.close();
    }
}

