/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository;

import junit.framework.TestCase;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;

public abstract class CascadeValueExceptionTest
extends TestCase {
    private static String queryStr1 = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\" < \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStr2 = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\" = \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private RepositoryConnection conn;
    private Repository repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValueExceptionLessThan() throws Exception {
        TupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStr1);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        try {
            CascadeValueExceptionTest.assertFalse((boolean)tupleQueryResult.hasNext());
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValueExceptionEqual() throws Exception {
        TupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStr2);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        try {
            CascadeValueExceptionTest.assertFalse((boolean)tupleQueryResult.hasNext());
        }
        finally {
            tupleQueryResult.close();
        }
    }

    protected void setUp() throws Exception {
        this.repository = this.createRepository();
        this.conn = this.repository.getConnection();
        this.conn.add((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        RepositoryConnection repositoryConnection = repository.getConnection();
        try {
            repositoryConnection.clear(new Resource[0]);
            repositoryConnection.clearNamespaces();
        }
        finally {
            repositoryConnection.close();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    protected void tearDown() throws Exception {
        this.conn.close();
        this.repository.shutDown();
    }
}

