/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.openrdf.model.Resource;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.UnsupportedRDFormatException;

public abstract class TupleQueryResultTest
extends TestCase {
    private Repository rep;
    private RepositoryConnection con;
    private String emptyResultQuery;
    private String singleResultQuery;
    private String multipleResultQuery;

    protected void setUp() throws Exception {
        this.rep = this.createRepository();
        this.con = this.rep.getConnection();
        this.buildQueries();
        this.addData();
    }

    protected void tearDown() throws Exception {
        this.con.close();
        this.rep.shutDown();
        super.tearDown();
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        RepositoryConnection repositoryConnection = repository.getConnection();
        repositoryConnection.clear(new Resource[0]);
        repositoryConnection.clearNamespaces();
        repositoryConnection.close();
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    private void buildQueries() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT * ");
        stringBuilder.append("FROM {X} P {Y} ");
        stringBuilder.append("WHERE X != X ");
        this.emptyResultQuery = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT DISTINCT P ");
        stringBuilder.append("FROM {} dc:publisher {P} ");
        stringBuilder.append("USING NAMESPACE ");
        stringBuilder.append("   dc = <http://purl.org/dc/elements/1.1/>");
        this.singleResultQuery = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT DISTINCT P, D ");
        stringBuilder.append("FROM {} dc:publisher {P}; ");
        stringBuilder.append("        dc:date {D} ");
        stringBuilder.append("USING NAMESPACE ");
        stringBuilder.append("   dc = <http://purl.org/dc/elements/1.1/>");
        this.multipleResultQuery = stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addData() throws IOException, UnsupportedRDFormatException, RDFParseException, RepositoryException {
        InputStream inputStream = TupleQueryResultTest.class.getResourceAsStream("/testcases/default-graph-1.ttl");
        try {
            this.con.add(inputStream, "", RDFFormat.TURTLE, new Resource[0]);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBindingNames() throws Exception {
        TupleQueryResult tupleQueryResult = this.con.prepareTupleQuery(QueryLanguage.SERQL, this.multipleResultQuery).evaluate();
        try {
            List list = tupleQueryResult.getBindingNames();
            if (!((String)list.get(0)).equals("P")) {
                TupleQueryResultTest.fail((String)("first header element should be 'P' but is '" + (String)list.get(0) + "'"));
            }
            if (!((String)list.get(1)).equals("D")) {
                TupleQueryResultTest.fail((String)("second header element should be 'D' but is '" + (String)list.get(1) + "'"));
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIterator() throws Exception {
        TupleQueryResult tupleQueryResult = this.con.prepareTupleQuery(QueryLanguage.SERQL, this.multipleResultQuery).evaluate();
        try {
            int n = 0;
            while (tupleQueryResult.hasNext()) {
                tupleQueryResult.next();
                ++n;
            }
            if (n <= 1) {
                TupleQueryResultTest.fail((String)"query should have multiple results.");
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsEmpty() throws Exception {
        TupleQueryResult tupleQueryResult = this.con.prepareTupleQuery(QueryLanguage.SERQL, this.emptyResultQuery).evaluate();
        try {
            if (tupleQueryResult.hasNext()) {
                TupleQueryResultTest.fail((String)"Query result should be empty");
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }
}

