/*
 * Decompiled with CFR 0.152.
 */
package com.franz.ag;

import com.franz.ag.AllegroGraph;
import com.franz.ag.AllegroGraphException;
import com.franz.ag.Cursor;
import com.franz.ag.JenaCursor;
import com.franz.ag.UPI;
import com.franz.ag.impl.AGFactory;
import com.franz.ag.util.AGInner;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.util.AGBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Hashtable;

public class AllegroGraphJenaImpl
extends GraphBase {
    AllegroGraph ag = null;
    Hashtable<Object, Object> anonAGtoJena = new Hashtable();
    Hashtable<Object, Object> anonJenaToAG = new Hashtable();

    public AllegroGraph getAllegroGraph() {
        return this.ag;
    }

    public AllegroGraphJenaImpl(AllegroGraph allegroGraph) {
        this.ag = allegroGraph;
    }

    Node lookupAGanon(UPI uPI, boolean bl) {
        Object object = this.anonAGtoJena.get(uPI);
        if (object != null) {
            return (Node)object;
        }
        if (!bl) {
            return null;
        }
        Node node = Node.createAnon();
        this.anonAGtoJena.put(uPI, node);
        this.anonJenaToAG.put(node, uPI);
        return node;
    }

    UPI lookupJenaAnon(Node_Blank node_Blank, boolean bl) throws AllegroGraphException {
        Object object = this.anonJenaToAG.get(node_Blank);
        if (object != null) {
            return (UPI)object;
        }
        if (!bl) {
            return null;
        }
        UPI uPI = this.ag.createBNodeIds(1)[0];
        this.anonAGtoJena.put(uPI, node_Blank);
        this.anonJenaToAG.put(node_Blank, uPI);
        return uPI;
    }

    public void performAdd(Triple triple) {
        try {
            this.ag.verifyEnabled().addTriple((AGBase)this.ag, this.decodeNode(triple.getSubject()), this.decodeNode(triple.getPredicate()), this.decodeNode(triple.getObject()), null);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new IllegalArgumentException(allegroGraphException.toString());
        }
    }

    String decodeRef(Node node) {
        Object object = this.decodeNode(node, false);
        if (object instanceof Long) {
            return object.toString();
        }
        if (object instanceof UPI) {
            String string = this.ag.refToString(object);
            return string;
        }
        return (String)object;
    }

    public void add(Triple[] tripleArray) throws AllegroGraphException {
        String[] stringArray = new String[tripleArray.length];
        String[] stringArray2 = new String[tripleArray.length];
        String[] stringArray3 = new String[tripleArray.length];
        for (int i = 0; i < tripleArray.length; ++i) {
            Triple triple = tripleArray[i];
            stringArray[i] = this.decodeRef(triple.getSubject());
            stringArray2[i] = this.decodeRef(triple.getPredicate());
            stringArray3[i] = this.decodeRef(triple.getObject());
        }
        this.ag.verifyEnabled().addTriples((AGBase)this.ag, (Object)stringArray, (Object)stringArray2, (Object)stringArray3, null);
    }

    public void performDelete(Triple triple) {
        try {
            this.ag.verifyEnabled().delete((AGBase)this.ag, this.decodeNode(triple.getSubject()), this.decodeNode(triple.getPredicate()), this.decodeNode(triple.getObject()), (Object)UPIImpl.nullUPI(), false);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new IllegalArgumentException(allegroGraphException.toString());
        }
    }

    public int graphBaseSize() {
        try {
            return (int)this.ag.verifyEnabled().numberOfTriples((AGBase)this.ag);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new IllegalStateException(allegroGraphException.toString());
        }
    }

    protected ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
        Cursor cursor;
        try {
            cursor = AGFactory.makeCursor((AllegroGraph)this.ag, (TriplesIterator)this.ag.verifyEnabled().getTriples(this.ag.agbase, this.decodeNode(tripleMatch.getMatchSubject(), true), this.decodeNode(tripleMatch.getMatchPredicate(), true), this.decodeNode(tripleMatch.getMatchObject(), true), (Object)UPIImpl.nullUPI(), 0));
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new IllegalArgumentException(allegroGraphException.toString());
        }
        return new JenaCursor(this, cursor);
    }

    Object decodeNode(Node node) {
        return this.decodeNode(node, false);
    }

    Object decodeNode(Node node, boolean bl) {
        if (node instanceof Node_Blank) {
            try {
                return this.lookupJenaAnon((Node_Blank)node, true);
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new IllegalStateException(allegroGraphException.toString());
            }
        }
        if (node instanceof Node_URI) {
            return AGInner.refNodeToString((String)node.getURI());
        }
        if (node instanceof Node_Literal) {
            Node_Literal node_Literal = (Node_Literal)node;
            return AGInner.refLitToString((String)node_Literal.getLiteralLexicalForm(), (String)this.getLanguageTag(node_Literal), (String)node_Literal.getLiteralDatatypeURI());
        }
        if (bl) {
            return null;
        }
        throw new IllegalArgumentException("Must be concrete Node");
    }

    String getLanguageTag(Node_Literal node_Literal) {
        String string = node_Literal.getLiteralLanguage();
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public static class V3_0_0B {
    }
}

