/*
 * Decompiled with CFR 0.152.
 */
package com.franz.ag;

import com.franz.ag.AllegroGraphException;
import com.franz.ag.AllegroGraphJenaImpl;
import com.franz.ag.Cursor;
import com.franz.ag.UPI;
import com.franz.ag.impl.CursorImpl;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.NoSuchElementException;

public class JenaCursor
extends NiceIterator
implements TripleIterator {
    private CursorImpl agcc;
    private AllegroGraphJenaImpl agji;

    JenaCursor(AllegroGraphJenaImpl allegroGraphJenaImpl, Cursor cursor) {
        this.agcc = (CursorImpl)cursor;
        this.agji = allegroGraphJenaImpl;
    }

    public void close() {
        this.agcc.close();
    }

    public boolean hasNext() {
        return this.agcc.hasNext();
    }

    Node encodeNode(UPI uPI, int n, String string, String string2) {
        Node node = this.encodeNodeInner(uPI, n, string, string2);
        if (this.ifDebug(2)) {
            try {
                this.agcc.getAG().ags.agc.evalInServer("(format t \"~&encodeNode: " + uPI + "  " + n + "  " + string + "  " + string2 + " ==> " + node.getClass().getName() + "~%\")");
            }
            catch (AllegroGraphException allegroGraphException) {
                // empty catch block
            }
        }
        return node;
    }

    Node encodeNodeInner(UPI uPI, int n, String string, String string2) {
        if (n == 1) {
            return this.agji.lookupAGanon(uPI, true);
        }
        if (n == 2) {
            return Node.createURI((String)string);
        }
        if (n == 3) {
            return Node.createLiteral((String)string);
        }
        if (n == 4) {
            return Node.createLiteral((String)string, (String)string2, (boolean)false);
        }
        if (n == 5) {
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getTypeByName(string2);
            return Node.createLiteral((String)string, null, (RDFDatatype)rDFDatatype);
        }
        throw new IllegalArgumentException("Cannot encode AG " + n + "=" + this.agcc.getAG().typeToString(n) + "/" + string + "/" + string2 + " to Jena Node");
    }

    boolean ifDebug(int n) {
        return this.agcc.getAG().ags.ifDebug(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        Object object = null;
        if (this.ifDebug(1)) {
            try {
                this.agcc.getAG().ags.serverTrace(true);
                object = this.nextInternal();
            }
            finally {
                this.agcc.getAG().ags.serverTrace(false);
            }
        } else {
            object = this.nextInternal();
        }
        return object;
    }

    public Object nextInternal() {
        try {
            if (this.agcc.step()) {
                Triple triple = new Triple(this.encodeNode(this.agcc.getS(), this.agcc.baseInstance.getPartType(1), this.agcc.baseInstance.getPartLabel(1), this.agcc.baseInstance.getPartMod(1)), this.encodeNode(this.agcc.baseInstance.getP(), this.agcc.baseInstance.getPartType(2), this.agcc.baseInstance.getPartLabel(2), this.agcc.baseInstance.getPartMod(2)), this.encodeNode(this.agcc.getO(), this.agcc.baseInstance.getPartType(3), this.agcc.baseInstance.getPartLabel(3), this.agcc.baseInstance.getPartMod(3)));
                return triple;
            }
            throw new NoSuchElementException();
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new IllegalStateException(allegroGraphException.toString());
        }
    }

    public void remove() {
        this.agcc.remove();
    }

    public Triple nextTriple() {
        return (Triple)this.next();
    }
}

