package com.franz.ag;

import java.util.Hashtable;

import com.franz.ag.AllegroGraph;
import com.franz.ag.AllegroGraphException;
import com.franz.ag.Cursor;
import com.franz.ag.UPI;
import com.franz.agbase.impl.UPIImpl;
import com.franz.ag.impl.AGFactory;
import com.franz.ag.util.AGInner;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

/**
 * 
 * @author mm
 *
 */
public class AllegroGraphJenaImpl extends GraphBase {
	
	/**
	 * The name of this class identifies the version of the AllegroGraph
	 * Java implementation.
	 * This name is also visible in the list of members in a jar file
	 * when it is inspected with Emacs or WinZip.
	 */
	public static class V3_0_0B {}
	
	
	AllegroGraph ag = null; 
	Hashtable<Object, Object> anonAGtoJena = new Hashtable<Object, Object>();
	Hashtable<Object, Object> anonJenaToAG = new Hashtable<Object, Object>();
	
	/**
	 * Return the AllegroGraph instance of this object.
	 * @return the AllegroGraph instance of this object.
	 */
	public AllegroGraph getAllegroGraph() { return ag; }
	
	/**
	 * Create an instance of this class to connect to one AllegroGraph
	 * database.
	 * <p>
	 * Before this constructor can be called, a connection to AllegroGraph
	 * must be established by creating an instance of AllegroGraphConnection,
	 * and a database must be opened with one of the accessor methods create(),
	 * open(), access(), renew(), or replace().
	 * 
	 * @param agi
	 */
	public AllegroGraphJenaImpl ( AllegroGraph agi ) {
		super();
		ag = agi;
	}
	
	/**
	 * Map a blank (anonymous) node from AllegroGraph to Jena.
	 * 
	 * @param key The AllegroGraph node UPI of the blank node.
	 * @param andAdd If true, create a new Jena Node_Blank instance when 
	 *     the UPI is not in the table.
	 * @return a Jena Node_Blank instance or null
	 */
	com.hp.hpl.jena.graph.Node lookupAGanon ( UPI key, boolean andAdd ) {
		Object val = anonAGtoJena.get(key);
		if ( val!=null )
			return (com.hp.hpl.jena.graph.Node)val;
		if ( !andAdd ) return null;
		com.hp.hpl.jena.graph.Node nd = com.hp.hpl.jena.graph.Node.createAnon();
		anonAGtoJena.put(key, nd);
		anonJenaToAG.put(nd, key);
		return nd;
	}
	
	/**
	 * Map a blank (anonymous) node from Jena to AllegroGraph.
	 * 
	 * @param nd A Jena Node_Blank instance.
	 * @param andAdd If true, create a new AllegroGraph blank node when
	 *      this is the first time we see the Node_Blank instance.
	 * @return The AllegroGraph node UPI or null.
	 * @throws AllegroGraphException if the blank node cannot be created.
	 */
	UPI lookupJenaAnon ( Node_Blank nd, boolean andAdd ) throws AllegroGraphException {
		Object v = anonJenaToAG.get(nd);
		if ( v!=null ) return ((UPI) v);
		if ( !andAdd ) return null;
		UPI lv = ag.createBNodeIds(1)[0];
		anonAGtoJena.put(lv, nd);
		anonJenaToAG.put(nd, lv);
		return lv;
	}

	public void performAdd(com.hp.hpl.jena.graph.Triple x) {
		try {
			ag.verifyEnabled().addTriple(ag,
										 decodeNode(x.getSubject()),
										 decodeNode(x.getPredicate()),
										 decodeNode(x.getObject()),
										 null
										 );
		} catch (AllegroGraphException e) {
			throw new IllegalArgumentException(e.toString());
		}
	}
	
	String decodeRef ( com.hp.hpl.jena.graph.Node nd ) {
		Object p = decodeNode(nd, false);
		if ( p instanceof Long ) return p.toString();
		if ( p instanceof UPI ) {
			String e = ag.refToString(p);
			//AllegroGraph.prdb( "decodeRef", ((nd instanceof Node_Blank)?p:nd) + " \"" + e + "\"");
			return e;
		}
		return (String)p;
	}
	
	public void add ( com.hp.hpl.jena.graph.Triple[] triples )
		throws AllegroGraphException {
		String[] s = new String[triples.length];
		String[] p = new String[triples.length];
		String[] o = new String[triples.length];
		for (int i = 0; i < triples.length; i++) {
			com.hp.hpl.jena.graph.Triple tr = triples[i];
			s[i] = decodeRef(tr.getSubject());
			p[i] = decodeRef(tr.getPredicate());
			o[i] = decodeRef(tr.getObject());			
		}
		ag.verifyEnabled().addTriples(ag, s, p, o, null);
	}
	
	public void performDelete(com.hp.hpl.jena.graph.Triple x) {
		try {
			ag.verifyEnabled().delete(ag,
										 decodeNode(x.getSubject()),
										 decodeNode(x.getPredicate()),
										 decodeNode(x.getObject()),
										 UPIImpl.nullUPI(),
										 false
										 );
		} catch (AllegroGraphException e) {
			throw new IllegalArgumentException(e.toString());
		}
	}
	
	public int graphBaseSize() {
		try {
			return (int)ag.verifyEnabled().numberOfTriples(ag);
		} catch (AllegroGraphException e) {
			throw new IllegalStateException(e.toString());
		}
	}
	


	protected ExtendedIterator graphBaseFind(TripleMatch x) {
		Cursor cc;
		try {
			cc = AGFactory.makeCursor(ag, ag.verifyEnabled().getTriples(ag.agbase,
					                 decodeNode(x.getMatchSubject(), true),
					                 decodeNode(x.getMatchPredicate(), true),
					                 decodeNode(x.getMatchObject(), true),
					                 UPIImpl.nullUPI(),
								     0));
		} catch (AllegroGraphException e) {
			throw new IllegalArgumentException(e.toString());
		}
		return new JenaCursor(this, cc);
	}

	Object decodeNode( com.hp.hpl.jena.graph.Node nd ) {
		return decodeNode(nd, false);
	}
	
	/**
	 * Convert a Jena Node instance to a suitable AllegroGraph
	 * node reference.
	 * 
	 * @param nd a Jena Node instance 
	 * @param wildOk If true, allow a wild node ref
	 * @return a node UPI or a string reference to a node or literal
	 */
	Object decodeNode( com.hp.hpl.jena.graph.Node nd, boolean wildOk ) {
		if ( nd instanceof Node_Blank) 
		{
			// lookup Jena id in AG/Jena map
			// if found, return new Long(AGid)
			// otherwise make a new BlankNode, add to map, return new Long(AGid)
			try {
				return lookupJenaAnon((Node_Blank) nd, true);
			} catch (AllegroGraphException e) {
				throw new IllegalStateException(e.toString());
			}
		}
		else if ( nd instanceof Node_URI ) 
			return AGInner.refNodeToString(nd.getURI());
			
		else if ( nd instanceof Node_Literal )
		{
			Node_Literal lt = (Node_Literal)nd;
			return AGInner.refLitToString(lt.getLiteralLexicalForm(),
								getLanguageTag(lt),
								lt.getLiteralDatatypeURI());
		}
		else if ( wildOk ) return null;
		else throw new IllegalArgumentException("Must be concrete Node");
	}
	
	String getLanguageTag ( Node_Literal x ) {
		String lang = x.getLiteralLanguage();
		if ( lang==null ) return null;
		if ( lang.equals("") ) return null;
		return lang;
	}
	
}
