/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna.biz/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.model;

import java.io.Serializable;

import org.openrdf.sesame.sail.StatementIterator;

/**
 * The interface for all RDF model values (URIs, BNodes and Literals).
 * All Value objects can be compared with eachother.
 *
 * @author Jeen Broekstra
 * @author Arjohn Kampman
 * @version $Revision: 1.1.2.1 $
 **/
public interface Value extends Comparable, Serializable {
	
	/**
	 * Gets all statements from the RDF graph for which this value is the object.
	 **/
	public StatementIterator getObjectStatements()
		throws GraphException;
}
