
//***** BEGIN LICENSE BLOCK *****
//Version: MPL 1.1
//
//The contents of this file are subject to the Mozilla Public License Version
//1.1 (the "License"); you may not use this file except in compliance with
//the License. You may obtain a copy of the License at
//http://www.mozilla.org/MPL/
//
//Software distributed under the License is distributed on an "AS IS" basis,
//WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
//for the specific language governing rights and limitations under the
//License.
//
//The Original Code is the AllegroGraph Java Client interface.
//
//The Original Code was written by Franz Inc.
//Copyright (C) 2006 Franz Inc.  All Rights Reserved.
//
//***** END LICENSE BLOCK *****

package com.franz.agjena.query;

import com.franz.agjena.exceptions.NiceException;
import com.franz.agjena.exceptions.UnimplementedMethodException;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;

/** 
 * A query processor wrapper
 */


public class AllegroGraphQueryExecution implements QueryExecution {
	
	//private AllegroGraph agStore = null;
	private FileManager fileManager = null;
	private AllegroGraphQuery query = null;
	private Dataset dataset = null;
	private Context context = null;
	private QuerySolution initialBinding = null;
	
//	protected void setAllegroGraphStore (AllegroGraph store) {
//		this.agStore = store;
//	}
	
	/** Constructor */
	protected AllegroGraphQueryExecution (Query query, Dataset dataset, Context context) {
		if (!(query instanceof AllegroGraphQuery))
			throw new NiceException("Non-AllegroGraph query passed to 'AllegroGraphQueryExecution'");
		this.query = (AllegroGraphQuery)query;
		this.dataset = dataset;
		this.context = context;
		//this.agStore = AllegroGraphModelFactory.getInstance().getAllegroGraphStore();
	}
	
    /** Set the FileManger that might be used to load files.
     *  May not be supported by all QueryExecution implementations.  
     * @throws UnsupportedMethodException 
     */
    public void setFileManager(FileManager fm) {
    	this.fileManager = fm;
    }
    
    /** Set the initial association of variables and values.
     * May not be supported by all QueryExecution implementations.
     * @param binding
     * @throws UnsupportedMethodException 
     */
    public void setInitialBinding(QuerySolution binding) {
    	this.initialBinding = binding;
    }

    /**
     * The dataset against which the query will execute.
     * May be null, implying it is expected that the query itself
     * has a dataset description. 
     */
    public Dataset getDataset() {return this.dataset;}
    
    /** The properties associated with a query execution -  
     *  implementation specific parameters  This includes
     *  Java objects (so it is not an RDF graph).
     *  Keys should be URIs as strings.  
     *  May be null (this implementation does not provide any configuration).
     */ 
    public Context getContext() {return this.context;}
    
    /** Execute a SELECT query */
	public ResultSet execSelect() {
		return this.query.executeSelectQuery(this.dataset);
	}
    
    /** Execute a CONSTRUCT query */
    public Model execConstruct() {
		return this.query.executeConstructQuery(this.dataset);
    }

    /** Execute a CONSTRUCT query, putting the statements into 'model'.
     *  @return Model The model argument for casaded code.
     */
    public Model execConstruct(Model model) {
    	throw new UnimplementedMethodException("execConstruct");
    }

    /** Execute a DESCRIBE query */
    public Model execDescribe() {
    	return this.query.executeDescribeQuery(this.dataset);
    }

    /** Execute a DESCRIBE query, putting the statements into 'model'.
     *  @return Model The model argument for casaded code.
     */
    public Model execDescribe(Model model) {
    	throw new UnimplementedMethodException("execDescribe");
    }

    /** Execute an ASK query */
    public boolean execAsk() {
    	return this.query.executeAskQuery(this.dataset);
    }
    
	/** Stop in mid execution.
	 *  No guarantee that the concrete implementation actual
     *  will stop or that it will do so immediately.
	 */

	public void abort() {
		throw new UnimplementedMethodException("Query abort not implemented.");
	}

    /** Close the query execution and stop query evaluation as soon as convenient.
     *  It is important to close query execution objects in order to release
     *  resources such as working memory and to stop the query execution.
     *  Some storage subsystems require explicit ends of operations and this
     *  operation will cause those to be called where necessary.
     */
	public void close() {
		// AllegroGraph apparently doesn't need to close query executors.
	}
    

}

/*
 *  (c) Copyright 2004, 2005, 2006, 2007, 2008 Hewlett-Packard Development Company, LP
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
