package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGCreateURI {

	/**
	 * Demonstrates some basics of creating URIs.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("createuri", AGPaths.TRIPLE_STORES);
		
		// Create a few URIs from strings 
		URINode subject = ts.createURI("http://example.org/Dog");  
		URINode predicate = ts.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");  
		URINode object = ts.createURI("http://www.w3.org/2002/07/owl#Class");
		
		AGUtils.showURI(subject);
		AGUtils.showURI(predicate);
		AGUtils.showURI(object);

		// Add a triple to the store (and add each URI to the store)
		ts.addStatement(subject, predicate, object);
		
		// You can also create a URI and add it to the store directly
		URINode u = (URINode)ts.addURI("http://www.w3.org/2002/07/owl#Class");
		AGUtils.showURI(u);
		
		// Or use the more generic addPart method (using N-Triples format)
		URINode v = (URINode)ts.addPart("<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>");
		AGUtils.showURI(v);

		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
}
