package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGLoadGzip {

	/**
	 * Demonstrates loading from a gzip'd N-Triples file.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create fresh triple-store.
		AllegroGraph ts = ags.renew("loadgzip", AGPaths.TRIPLE_STORES);
		
		// Load a gzip'd N-Triples file
		long n = ts.loadNTriples(AGPaths.dataSources("wilburwine.nt.gz"), "", false, null, null, true);
		System.out.println("Loaded " + n + " triples.");
		
		// Get triples from the default graph and show them.
		TriplesIterator it = ts.getStatements(null, null, null);
		AGUtils.showTriples(it);
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
