package com.franz.agbase.examples;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.PrologSelectQuery;
import com.franz.agbase.AllegroGraph.StoreAttribute;

public class AGLubm50Prolog {

	public static int port = 4126;
	public static String store =  AGPaths.TRIPLE_STORES + "LUBM-50";
	public static String ubnamespace = "http://www.lehigh.edu/%7Ezhp2/2004/0401/univ-bench.owl#";
	
	/**
	 * Demonstrates Prolog Select versions of the LUBM benchmark queries 
	 * on the LUBM 50 data set.
	 * 
	 * Note that RDFS++ reasoning must be enabled to obtain the correct
	 * answers.
	 * 
	 * This example assumes that the LUBM-50 triple store has already 
	 * been built.  Please refer to AGLubm50Build.java to build it.
	 * 
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {

		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.setPort(port);
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Open the LUBM triple store read-only, which must already exist
		AllegroGraph ts = new AllegroGraph(store); 
		ts.setAttribute(StoreAttribute.READ_ONLY, true);
		ags.open(ts);
		System.out.println(store + ": " + ts.numberOfTriples() + " triples.");
		
		// Register namespaces used in queries 
		ts.registerNamespace("ub", ubnamespace);
		ts.registerNamespace("u0d0", "http://www.Department0.University0.edu/");
		
		// Add Prolog rule needed for query 12. 
		String rule = "(<-- (Chair ?x1)" +
	    	"(q ?x1 !ub:headOf ?y)" +
	    	"(q ?x1 !rdf:type !ub:Person)" +
	    	"(q ?y !rdf:type !ub:Department))";
		ags.addPrologRule(rule);
		
		// Run the LUBM queries with RDFS++ reasoning enabled
		doQuery1(ts);
		doQuery2(ts);
		doQuery3(ts);
		doQuery4(ts);
		doQuery5(ts);
		doQuery6(ts); 
		doQuery7(ts); 
		doQuery8(ts);
		doQuery9(ts);
		doQuery10(ts);
		doQuery11(ts);
		doQuery12(ts);
		doQuery13(ts);
		doQuery14(ts);

		// Close the triple store and disconnect from the server.
	    ts.closeTripleStore();
	    ags.disable();
 	}
	
	public static void doQuery1(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x"};
		String query = 
			"(q ?x !ub:takesCourse !u0d0:GraduateCourse0)" +
			"(q ?x !rdf:type !ub:GraduateStudent)";
		doQuery(ts,1,vars,query);
	}
		
	public static void doQuery2(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x","y","z"};
		String query = 
			  "(q ?z !rdf:type !ub:Department)" +
			  "(q ?z !ub:subOrganizationOf ?y)" + 
			  "(q ?x !ub:undergraduateDegreeFrom ?y)" +
			  "(q ?x !ub:memberOf ?z)" +
			  "(q ?x !rdf:type !ub:GraduateStudent)" +
			  "(q ?y !rdf:type !ub:University)";
		doQuery(ts,2,vars,query);
	}
		
	public static void doQuery3(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x"};
		String query = 
			 "(q ?x !ub:publicationAuthor !u0d0:AssistantProfessor0)" +
			 "(q ?x !rdf:type !ub:Publication)";
		doQuery(ts,3,vars,query);
	}
	    
	public static void doQuery4(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x","name","email","telephone"};
		String query = 
			"(q ?x !ub:worksFor !<http://www.Department0.University0.edu>)" +
			"(q ?x !rdf:type !ub:Professor)" +
			"(q ?x !ub:name ?name)" +
			"(q ?x !ub:emailAddress ?email)" +
			"(q ?x !ub:telephone ?telephone)";
		doQuery(ts,4,vars,query);
	}
	    
	public static void doQuery5(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x"};
		String query = 
			"(q ?x !ub:memberOf !<http://www.Department0.University0.edu>)" +
			"(q ?x !rdf:type !ub:Person)";
		doQuery(ts,5,vars,query);
	}
	    
	public static void doQuery6(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x"};
		String query = 
			"(q ?x !rdf:type !ub:Student)";
		doQuery(ts,6,vars,query);
	}
	    
	public static void doQuery7(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x","y"};
		String query = 
			 "(q !u0d0:AssociateProfessor0 !ub:teacherOf ?y)" +
			 "(q ?y !rdf:type !ub:Course)" +
			 "(q ?x !ub:takesCourse ?y)" +
			 "(q ?x !rdf:type !ub:Student)";
		doQuery(ts,7,vars,query);
	}
	    
	public static void doQuery8(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"y","x","email"};
		String query =
			"(q ?y !ub:subOrganizationOf !<http://www.University0.edu>)" +
			"(q ?y !rdf:type !ub:Department)" +
			"(q ?x !ub:memberOf ?y)" +
			"(q ?x !rdf:type !ub:Student)" +
			"(q ?x !ub:emailAddress ?email)";
		doQuery(ts,8,vars,query);
	}
	    
	public static void doQuery9(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x","y","z"};
		String query =
			"(q ?x !ub:advisor ?y)" +       
			"(q ?x !ub:takesCourse ?z)" +
			"(q ?y !ub:teacherOf ?z)" +
			"(q ?x !rdf:type !ub:Student)" +
			"(q ?y !rdf:type !ub:Faculty)" +
			"(q ?z !rdf:type !ub:Course)";
		doQuery(ts,9,vars,query);
	}
	    
	public static void doQuery10(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x"};
		String query =
			"(q ?x !ub:takesCourse !u0d0:GraduateCourse0)" +
			"(q ?x !rdf:type !ub:Student)";
		doQuery(ts,10,vars,query);
	}
	    
	public static void doQuery11(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x"};
		String query =
			"(q ?x !ub:subOrganizationOf !<http://www.University0.edu>)" +
			"(q ?x !rdf:type !ub:ResearchGroup)";
		doQuery(ts,11,vars,query);
	}
	    
	public static void doQuery12(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x","y"};
		String query =
			"(q- ?y !ub:subOrganizationOf !<http://www.University0.edu>)" +
			"(q ?y !rdf:type !ub:Department)" +
			"(q ?x !ub:memberOf ?y)" +
			"(Chair ?x)";
		doQuery(ts,12,vars,query);
	}
	    
	public static void doQuery13(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x"};
		String query =
			"(q !<http://www.University0.edu> !ub:hasAlumnus ?x)" +
			"(q ?x !rdf:type !ub:Person)";
		doQuery(ts,13,vars,query);
	}
	    
	public static void doQuery14(AllegroGraph ts) throws AllegroGraphException {
		String[] vars = new String[]{"x"};
		String query =
			"(q ?x !rdf:type !ub:UndergraduateStudent)";
		doQuery(ts,14,vars,query);
	}
	
	public static void doQuery(AllegroGraph ts, int qi, String[] vars, String query) throws AllegroGraphException {
		System.out.print("Query " + qi + ": ");
		PrologSelectQuery psq = new PrologSelectQuery();
		psq.setTripleStore(ts);
		psq.setVariables(vars);
		psq.setQuery(query);
		psq.setIncludeInferred(true);
		long begin = System.nanoTime();
		long n = psq.count();
		long delta = (System.nanoTime() - begin);
		System.out.println(n + " answers in " + (delta/1000000000.0) + " seconds.");
	}
}
