package com.franz.agbase.examples;


import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.examples.AGLubm50Prolog;

public class AGLubm8000Prolog {

	/**
	 * Demonstrates Prolog Select versions of the LUBM benchmark queries 
	 * on the LUBM 8000 data set.
	 * 
	 * This example assumes that the LUBM-8000 triple store has already 
	 * been built.  Please refer to AGLubm8000Build.java to build it.
	 * 
	 * Note that we simply reuse the LUBM 50 prolog queries here, and
	 * point instead to the LUBM-8000 store.
	 *  
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		AGLubm50Prolog.port = 4126;
		AGLubm50Prolog.store = "/stores/LUBM-8000";
		AGLubm50Prolog.ubnamespace = "http://lubm.franz.com#";
		AGLubm50Prolog.main(args);
	}
}
