package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGNamespaceRegistries {
	
	/**
	 * Demonstrates some basic facts and use of namespace registries.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Show the namespace definitions registered with the server
		AGUtils.printStringArray("AGS Namespaces (initially):",ags.getNamespaces());

		// Create a fresh triple-store.
		AllegroGraph ts = ags.renew("namespaces", AGPaths.TRIPLE_STORES);

		// Show the namespace definitions available to this triple store
		// Each triple store maintains its own namespaces initialized by server namespaces
		AGUtils.printStringArray("TS Namespaces (initially):",ts.getNamespaces());

		// Add a namespace to the server's namespace registry
		// (future triple store namespaces will be initialized with it)
		ags.registerNamespace("ns1", "http://www.example.com/ns1#");

		// Add a namespace to the triple store's registry
		ts.registerNamespace("ns2", "http://www.example.com/ns2#");

		// Show the namespaces registered with the server and the triplestore
		AGUtils.printStringArray("AGS Namespaces (added ns1):",ags.getNamespaces());
		AGUtils.printStringArray("TS Namespaces: (added ns2)",ts.getNamespaces());

		// Redefine a namespace
		ts.registerNamespace("ns1", "http://www.example.com/ns1a#");

		// Remove a namespace
		ts.registerNamespace("ns2", null);

		// Show the namespace definitions for the triplestore
		AGUtils.printStringArray("TS Namespaces: (redefined ns1, removed ns2)",ts.getNamespaces());

		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
	
}
