package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGNtriplesTest {

	/**
	 * Demonstrates how to load an N-Triples test file.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create fresh triple-store.
		AllegroGraph ts = ags.renew("testnt", AGPaths.TRIPLE_STORES);
		
		// Load the N-Triples test file
		String ntripleFile = AGPaths.dataSources("test.nt");		
		System.out.println("Loading N-Triples " + ntripleFile);
		long n = ts.loadNTriples(ntripleFile);
		System.out.println("Loaded " + n + " triples.");
		
		// Get all triples from the default graph and show them.
		TriplesIterator cc = ts.getStatements(null, null, null);
		AGUtils.showTriples(cc);
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
