package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGOpenCyc {

	/**
	 * Demonstrates loading and indexing the Open CYC data set.
	 * 
	 * The data that is necessary to run this example is available at:
	 * http://franzdownload.com/allegrograph/data/open-cyc.nt.bz2
	 * 
	 * This example assumes that the data will be unpacked into a file
	 * open-cyc.nt in the AGPaths.DATA_SOURCES directory; modify this
	 * location as necessary.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {

		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.setPort(4126);
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Estimate the number of unique resources in the Open CYC data
		// Simple heuristic: a little more than 1/3 of the total triples  
		ags.setDefaultExpectedResources(250000);

		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("OpenCyc", AGPaths.TRIPLE_STORES);

		// Load the N-Triples file -- modify the location as necessary.
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("open-cyc.nt"));

		// Index the store
		AGIndexAllTriples.indexAllTriplesWithTiming(ts);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
}
