package com.franz.agbase.examples;

import java.io.File;
import java.io.IOException;

import com.franz.agbase.*;

/**
 * 
 * Specify path information required by the AllegroGraph Examples.
 *  
 */
public class AGPaths {
	
	/**
	 * The system directory where the AllegroGraph Examples are installed.  
	 * The default setting should be adequate for running within Eclipse, 
	 * but may need modification to run from a command line.
	 */
	public static String EXAMPLES_ROOT = System.getProperty("user.dir");
	
	/**
	 * A server-accessible directory that will house example triple stores
	 * constructed by the server -- the directory must exist.  The default
	 * is the ts/ subdirectory of this AllegroGraph Examples distribution.
	 * Modify this if you want your example stores constructed elsewhere.
	 */
	public static String TRIPLE_STORES = EXAMPLES_ROOT + "/ts/";
	
	/**
	 * A server-accessible directory containing example data sources for loading
	 * stores. The default location is the data/ subdirectory of this AllegroGraph
	 * Examples distribution.
	 */
	public static String DATA_SOURCES = EXAMPLES_ROOT + "/data/";
	
	// Check that paths are properly configured at start up
	static {
		//checkPaths();
	}
	
    public static void main(String[] args) {
        showPaths();
    }
    
    public static void showPaths() {
        System.out.println("AllegroGraph Paths");
        System.out.println("  EXAMPLES_ROOT: " + EXAMPLES_ROOT);
        System.out.println("  TRIPLE_STORES: " + TRIPLE_STORES);
        System.out.println("  DATA_SOURCES : " + DATA_SOURCES);
    }

	public static String dataSources(String relPath) throws AllegroGraphException {
		String fp;
		try {
			fp = (new File(DATA_SOURCES+relPath)).getCanonicalPath();
		} catch (IOException e) {
			throw new AllegroGraphException(e.getMessage());
		}
		return fp;
	}
	
	public static boolean checkPaths() {
		File root = new File(EXAMPLES_ROOT);
		File ts = new File(TRIPLE_STORES);
		File data = new File(DATA_SOURCES);
		boolean allDirsExist = false;
		if (root.isDirectory() && ts.isDirectory() && data.isDirectory()) {
			allDirsExist = true;
		} else {
			System.out.println("Please ensure paths for TRIPLE_STORES and DATA_SOURCES are properly configured in AGPaths.java for your system.");
			showPaths();
			System.exit(1);
		}
		return allDirsExist;
	}
}