package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGRDFAxioms {

	/**
	 * Demonstrates loading the RDF Axioms.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store.
		AllegroGraph ts = ags.renew("RDFAxioms", AGPaths.TRIPLE_STORES);

		// Load the RDF axioms.
		String rdf = AGPaths.dataSources("rdf-axioms.rdf");
		System.out.println("Loading RDF from " + rdf);
		Long n = ts.loadRDFXML(rdf);
		System.out.println("Loaded " + n + " triples.");

		// Index all triples for faster querying and wait until done.
		ts.indexAllTriples(true);
		
		// Get all triples and show them.
		TriplesIterator cc = ts.getStatements(null, null, null);
		AGUtils.showTriples(cc);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
	
}
