package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGRangeQueries {

	/**
	 * Demonstrates some basics of range queries. 
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
	
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("rangequeries", AGPaths.TRIPLE_STORES);

		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store using encoded literals
		// Encoded literals are necessary when performing range queries 
		ts.addStatement("!ex:person1","!ex:age", ts.createEncodedLiteral(28,"int"));
		ts.addStatement("!ex:person2","!ex:age", ts.createEncodedLiteral(30,"int"));
		ts.addStatement("!ex:person3","!ex:age", ts.createEncodedLiteral(32,"int"));
		ts.addStatement("!ex:person4","!ex:age", ts.createEncodedLiteral(40,"int"));
		ts.addStatement("!ex:person5","!ex:age", ts.createEncodedLiteral(42,"int"));
		
		// Retrieve triples by matching a range of objects
		EncodedLiteral low = ts.createEncodedLiteral(30,"int");
		EncodedLiteral high = ts.createEncodedLiteral(40,"int");
		System.out.println("Retrieving triples with range 30 <= ex:age <= 40");
		TriplesIterator it = ts.getStatements(null, "!ex:age", low, high, null, null);
		AGUtils.showTriples(it);

		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
