package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGReasoningDomainRange {

	/**
	 * Demonstrates reasoning involving rdfs:domain and rdfs:range
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("domainrange", AGPaths.TRIPLE_STORES);
				
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:a","!ex:p", "!ex:b");
		ts.addStatement("!ex:p","!rdfs:domain", "!ex:D");
		ts.addStatement("!ex:p","!rdfs:range", "!ex:R");
		
		// Retrieve some triples without reasoning (none in this case)
		TriplesIterator cc = ts.getStatements(false,null,"!rdf:type",null);
		System.out.println("Retrieving all rdf:type's in the store (should be none):");
		AGUtils.showTriples(cc);

		// Now demonstrate reasoning
		cc = ts.getStatements(true,"!ex:a","!rdf:type",null);
		System.out.println("Inferring the rdf:type of ex:a");
		AGUtils.showTriples(cc);
		cc = ts.getStatements(true,"!ex:b","!rdf:type",null);
		System.out.println("Inferring the rdf:type of ex:b");
		AGUtils.showTriples(cc);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}