package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGReasoningSameAs {

	/**
	 * Demonstrates reasoning involving owl:sameAs
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sameas", AGPaths.TRIPLE_STORES);
		
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:a","!owl:sameAs", "!ex:b");
		ts.addStatement("!ex:b","!owl:sameAs", "!ex:c");
		ts.addStatement("!ex:c","!ex:p", "!ex:d");
		
		// Retrieve some triples without reasoning 
		TriplesIterator cc = ts.getStatements(false,"!ex:a",null,"!ex:c");
		System.out.println("Ground triples relating ex:a and ex:c (should be none):");
		AGUtils.showTriples(cc);

		// Now demonstrate reasoning
		cc = ts.getStatements(true,"!ex:a",null,"!ex:c");
		System.out.println("Infer triples relating ex:a and ex:c");
		AGUtils.showTriples(cc);
		cc = ts.getStatements(true,"!ex:a",null,"!ex:d");
		System.out.println("Infer triples relating ex:a and ex:d");
		AGUtils.showTriples(cc);

		// Add some more triples to the store
		ts.addStatement("!ex:jans","!ex:owns","!ex:birra");  
		ts.addStatement("!ex:jans","!owl:sameAs","!ex:jannes");  
		ts.addStatement("!ex:aasman","!owl:sameAs","!ex:jannes");  
		ts.addStatement("!ex:birra","!owl:sameAs","!ex:son-of-samira");  

		// Now demonstrate more reasoning
		cc = ts.getStatements(true,"!ex:aasman",null,"!ex:son-of-samira");
		System.out.println("Infer triples relating ex:aasman and ex:son-of-samira");
		AGUtils.showTriples(cc);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}