package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGReasoningSubPropertyOf {

	/**
	 * Demonstrates basic reasoning involving rdfs:subPropertyOf
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("subpropertyof", AGPaths.TRIPLE_STORES);
		
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:p","!rdfs:subPropertyOf", "!ex:q");
		ts.addStatement("!ex:q","!rdfs:subPropertyOf", "!ex:r");
		ts.addStatement("!ex:a","!ex:p", "!ex:b");
		
		// Retrieve some triples without reasoning 
		TriplesIterator cc = ts.getStatements(false,"!ex:p","!rdfs:subPropertyOf",null);
		System.out.println("Retrieving super-properties of ex:p");
		AGUtils.showTriples(cc);

		// Now with reasoning
		cc = ts.getStatements(true,"!ex:p","!rdfs:subPropertyOf",null);
		System.out.println("Inferring super-properties of ex:p");
		AGUtils.showTriples(cc);

		// Retrieve without reasoning properties that hold between ex:a and ex:b
		cc = ts.getStatements(false,"!ex:a",null,"!ex:b");
		System.out.println("Retrieving properties that hold between ex:a and ex:b");
		AGUtils.showTriples(cc);

		// Now with reasoning
		cc = ts.getStatements(true,"!ex:a",null,"!ex:b");
		System.out.println("Inferring properties that hold between ex:a and ex:b");
		AGUtils.showTriples(cc);
		
		// Close the store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}