package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSNAMetrics {

	/**
	 * Demonstrates computing various centrality metrics in a Social Network.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple-store.
		AllegroGraph ts = ags.renew("snametrics", AGPaths.TRIPLE_STORES);
		
		// Register namespaces
		ts.registerNamespace("ex", "http://example.org/");
		
		// Load a small graph of data
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("sna-doublediamond.nt"));
		
		// Get an SNA extension instance for this store to work with SNA features 
		SNAExtension sna = ts.getSNAExtension();
		
		// Register a generator
		Object[] parts = new Object[2];
		parts[0] = "objects-of";
		parts[1] = "!ex:to";
		sna.registerGenerator("to", parts);
		
		// Define a group of actors
		String[] group = {"!ex:a","!ex:b","!ex:c","!ex:d","!ex:e","!ex:f","!ex:g","!ex:h"};
		
		// Show the Betweenness centrality of every actor in the group 
		for (int i=0;i<group.length;i++) {
			double bc = sna.getBetweennessCentrality(group[i], group, "to");
			System.out.println("Betweenness Centrality of " + group[i] + " is " + bc);
		}
		
		// Show the Closeness centrality of every actor in the group
		for (int i=0;i<group.length;i++) {
			double bc = sna.getClosenessCentrality(group[i], group, "to");
			System.out.println("Closeness Centrality of " + group[i] + " is " + bc);
		}
		
		// Show the Degree centrality of every actor in the group
		for (int i=0;i<group.length;i++) {
			double bc = sna.getDegreeCentrality(group[i], group, "to");
			System.out.println("Degree Centrality of " + group[i] + " is " + bc);
		}
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
