package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSerializers {

	/**
	 * Demonstrates how to load a triple store from an N-Triples file.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create fresh triple-store.
		AllegroGraph ts = ags.renew("serializers", AGPaths.TRIPLE_STORES);
		
		// Load the file in N-Triples format
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("temporal.nt"));
		
		// Serialize the store to files in various formats
		NTriplesSerializer ntser = new NTriplesSerializer();
		ntser.setDestination(AGPaths.dataSources("temporal-serialized.nt"));
		ntser.setIfExists("supersede");
		ntser.run(ts);
		
		RDFSerializer rdfser = new RDFSerializer();
		rdfser.setDestination(AGPaths.dataSources("temporal-serialized.rdf"));
		rdfser.setIfExists("supersede");
		rdfser.run(ts);
		
		RDFN3Serializer rdfn3ser = new RDFN3Serializer();
		rdfn3ser.setDestination(AGPaths.dataSources("temporal-serialized.n3"));
		rdfn3ser.setIfExists("supersede");
		rdfn3ser.run(ts);
		
		RDFManifestSerializer rdfmanser = new RDFManifestSerializer();
		rdfmanser.setDestination(AGPaths.dataSources("temporal-serialized.manifest"));
		rdfmanser.run(ts);
		
		// Serialize from a TriplesIterator to a file
		TriplesIterator cc = ts.getStatements(null,null,"<http://example.org/pt3>");
		AGUtils.showTriples(cc);
		ntser.setDestination(AGPaths.dataSources("temporal-intervals-using-pt3.nt"));
		ntser.setIfExists("supersede");
		//ntser.run(cc);
		
		// Serialize from a TriplesIterator to a string
		cc = ts.getStatements(null,null,"<http://example.org/pt3>");
		ntser = new NTriplesSerializer();
		ntser.setDestination(null);
		//String result = (String)(ntser.run(cc));
		//System.out.print(result);
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
