package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlAsk {

	/**
	 * Demonstrates some basics of using ASK in SPARQL
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparql", AGPaths.TRIPLE_STORES);
		
		// The briefest possible SPARQL query:
		String query = "ASK {}";
		
		// Query the store and show the result
		SPARQLQuery sq = new SPARQLQuery();
		boolean result = sq.ask(ts, query);
		System.out.println("Query: " + query);
		System.out.println("Result: " + result);
			
		// Register any namespaces
		ts.registerNamespace("foaf", "http://xmlns.com/foaf/0.1/");

		// Define blank nodes
		BlankNode a = (BlankNode)ts.createBNode("_:a");
		BlankNode b = (BlankNode)ts.createBNode("_:b");
		
		// Add some data to the store
		ts.addStatement(a,"!rdf:type","!foaf:Person");
		ts.addStatement(a,"!foaf:name",ts.createLiteral("Alice"));
		ts.addStatement(a,"!foaf:mbox","<mailto:alice@example.com>");
		ts.addStatement(a,"!foaf:mbox","<mailto:alice@work.example>");
		ts.addStatement(b,"!rdf:type","!foaf:Person");
		ts.addStatement(b,"!foaf:name",ts.createLiteral("Bob"));
		ts.addStatement(b,"!foaf:homepage","<http://work.example.org/alice/>");

		query =
		"PREFIX foaf:    <http://xmlns.com/foaf/0.1/> " +
		"ASK  { ?x foaf:name  'Alice' }";
		
		// Query the store and show the result
		sq = new SPARQLQuery();
		result = sq.ask(ts, query);
		System.out.println("Query: " + query);
		System.out.println("Result: " + result);
		
		query =
		"PREFIX foaf:    <http://xmlns.com/foaf/0.1/> " +
		"ASK  { ?x foaf:name  'Fred' }";
			
		// Query the store and show the result
		sq = new SPARQLQuery();
		result = sq.ask(ts, query);
		System.out.println("Query: " + query);
		System.out.println("Result: " + result);
			
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}