package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlDistinct {

	/**
	 * Demonstrates some basics of using DISTINCT in SPARQL
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparql", AGPaths.TRIPLE_STORES);
				
		// Register any namespaces
		ts.registerNamespace("foaf", "http://xmlns.com/foaf/0.1/");

		// Define blank nodes
		BlankNode x = (BlankNode)ts.createBNode("_:x");
		BlankNode y = (BlankNode)ts.createBNode("_:y");
		BlankNode z = (BlankNode)ts.createBNode("_:z");
		
		// Add some data to the store
		ts.addStatement(x,"!foaf:name",ts.createLiteral("Alice"));
		ts.addStatement(x,"!foaf:mbox","<mailto:alice@example.com>");
		ts.addStatement(y,"!foaf:name",ts.createLiteral("Alice"));
		ts.addStatement(y,"!foaf:mbox","<mailto:asmith@example.com>");
		ts.addStatement(z,"!foaf:name",ts.createLiteral("Alice"));
		ts.addStatement(z,"!foaf:mbox","<mailto:alice.smith@example.com>");

		// Query first without using the DISTINCT solution modifier.
		// Note that duplicate solutions are preserved.
		String query =
		"PREFIX foaf:    <http://xmlns.com/foaf/0.1/> " +
		"SELECT ?name WHERE { ?x foaf:name ?name } ";
		
		// Query the store and show the results
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// Now query using DISTINCT
		query =
		"PREFIX foaf:    <http://xmlns.com/foaf/0.1/> " +
		"SELECT DISTINCT ?name WHERE { ?x foaf:name ?name } ";
			
		// Query the store and show the results
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);
			
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}