package com.franz.agbase.examples;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.EncodedLiteral;
import com.franz.agbase.TriplesIterator;

public class AGTemporalCalendars {

	/**
	 * Demonstrates converting Gregorian Calendar objects into date-time objects
	 * for storage and performing a range query.
	 * 
	 * @param unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {

		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("gregorian", AGPaths.TRIPLE_STORES);
		
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
		GregorianCalendar cal = new GregorianCalendar();
		String date;
				
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store using encoded literals
		// Encoded literals are necessary when performing range queries 
		cal.set(1932, Calendar.JANUARY, 1, 0, 0, 1); 
		date = sdf.format(cal.getTime());
		ts.addStatement("!ex:person1","!ex:birthdate", ts.createEncodedLiteral(date,"date-time"));
		cal.set(1948, Calendar.FEBRUARY, 29, 23, 59, 59); 
		date = sdf.format(cal.getTime());
		ts.addStatement("!ex:person2","!ex:birthdate", ts.createEncodedLiteral(date,"date-time"));
		cal.set(1968, Calendar.MARCH, 17, 8, 0, 0); 
		date = sdf.format(cal.getTime());
		ts.addStatement("!ex:person3","!ex:birthdate", ts.createEncodedLiteral(date,"date-time"));
		cal.set(1988, Calendar.APRIL, 3, 9, 0, 0); 
		date = sdf.format(cal.getTime());
		ts.addStatement("!ex:person4","!ex:birthdate", ts.createEncodedLiteral(date,"date-time"));
		cal.set(2007, Calendar.JUNE, 31, 12, 0, 0); 
		date = sdf.format(cal.getTime());
		ts.addStatement("!ex:person5","!ex:birthdate", ts.createEncodedLiteral(date,"date-time"));
		
		// Retrieve triples by matching a range of objects
		cal.set(1980, Calendar.JANUARY, 1, 0, 0, 0); date = sdf.format(cal.getTime());
		EncodedLiteral low = ts.createEncodedLiteral(date,"date-time");
		cal.set(1989, Calendar.DECEMBER, 31, 23, 59, 59); date = sdf.format(cal.getTime());
		EncodedLiteral high = ts.createEncodedLiteral(date,"date-time");
		System.out.println("Retrieving triples for birthdates in the 1980's:");
		TriplesIterator it = ts.getStatements(null, "!ex:birthdate", low, high, null, null);
		AGUtils.showTriples(it);

		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();		
	}
}
