package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGTripleIds {

	/**
	 * Demonstrates some basics of triple ids.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("tripleids", AGPaths.TRIPLE_STORES);
		

		// Register any namespaces
		ts.registerNamespace("ex","http://example.org/");

		// Create some triples and add them to the store
		Triple tr1 = ts.newTriple("!ex:Dog","!rdf:type","!owl:Class");  
		Triple tr2 = ts.newTriple("!ex:Dog","!rdfs:subClassOf","!ex:Mammal"); 
		
		// Show the triples and note their ids
		System.out.println("Created and added the following triples to the store:");
		AGUtils.showTriple(tr1);
		AGUtils.showTriple(tr2);
		
		// Get the id for a triple
		long tr2_id = tr2.queryAGId();
		
		// You can also use triple ids to assert facts about triples
		// This can be more space and time efficient than reifying
		// but this is not RDF semantics
		EncodedLiteral lit = ts.createEncodedLiteral(tr2_id,"triple-id");
		Triple tr3 = ts.newTriple("!ex:person1", "!ex:believes", lit);
		AGUtils.showTriple(tr3);
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
}
