package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGTriplesQueryCount {

	/**
	 * Demonstrates using the TriplesQuery count method. 
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("triplesquerycount", AGPaths.TRIPLE_STORES);

		ts.registerNamespace("ex", "http://example.org/");
		
		ts.addStatement("!ex:a","!ex:p", "!ex:b", "<g>");
		ts.addStatement("!ex:a","!ex:q", "!ex:b", "<g>");
		ts.addStatement("!ex:a","!ex:r", "!ex:b", "<g>");
		ts.addStatement("!ex:a","!ex:s", "!ex:b", "<g>");
		ts.addStatement("!ex:a","!ex:t", "!ex:b", "<h>");
		ts.addStatement("!ex:a","!ex:u", "!ex:b", "<h>");
		
		TriplesQuery tq = new TriplesQuery();
		tq.setContext("<g>");
		long g_count = tq.count(ts);
		System.out.println("Number of triples in context g: " + g_count);
		
		tq.setContext("<h>");
		long h_count = tq.count(ts);
		System.out.println("Number of triples in context h: " + h_count);
		
		
		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
