package com.franz.agbase.examples;

import com.franz.agbase.*;
import java.io.File;

public class AGWordNet {

	/**
	 * Demonstrates loading and indexing a triple store with WordNet data
	 * 
	 * The WordNet data for this example is available at
	 * http://www.w3.org/2006/03/wn/wn20/download/wn20full.zip
	 * 
	 * This example assumes that the data will be unpacked into the
	 * wordnet/ subdir of the AGPaths.DATA_SOURCES directory.
	 * 
	 * @throws AllegroGraphException 
	 */		
	public static void main(String[] args) throws AllegroGraphException {

		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("WordNet", AGPaths.TRIPLE_STORES);
				
		// Get the list of rdf files to load -- assumes the WordNet
		// directory contains only files that are to be loaded 
		String wordnetroot = AGPaths.dataSources("wordnet/");
		File wordnetdir = new File(wordnetroot);
		File[] nt = wordnetdir.listFiles();
		
		// Load all of the necessary files into a store
		long start = System.currentTimeMillis();
		for (int i = 0; i < nt.length; i++) {
			String rdfFile = wordnetroot + nt[i].getName();
			System.out.println(i + " of " + nt.length + ": " + rdfFile);
			AGLoadRDF.loadRDFWithTiming(ts, rdfFile);
		}
		System.out.println("Total: loaded " + ts.numberOfTriples() 
				+ " triples in " + AGUtils.elapsedTime(start));

		// Index the store
		AGIndexAllTriples.indexAllTriplesWithTiming(ts);

		// Close the store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
 	}
	
}
