package com.franz.agjena.examples;


import java.io.InputStream;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.examples.AGPaths;
import com.franz.agjena.AllegroGraphGraphMaker;
import com.franz.agjena.AllegroGraphModel;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.VCARD;

public class AGJenaSelectors {

	/**
	 * Demonstrates Jena Tutorial 08 using AllegroGraph: selectors.
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("jenatutorial08", AGPaths.TRIPLE_STORES);

		// Create a Graph maker for the store
	    AllegroGraphGraphMaker maker = new AllegroGraphGraphMaker(ts);
        String inputFileName = AGPaths.dataSources("vc-db-1.rdf");
        Graph graph = maker.createGraph("http://foo#bar");
        Model model = new AllegroGraphModel(graph);
      
        // use the FileManager to find the input file
        InputStream in = FileManager.get().open(inputFileName);
        if (in == null) {
        	throw new IllegalArgumentException( "File: " + inputFileName + " not found");
        }
 
        // read the RDF/XML file
        model.read( in, "" );
        
        // select all the resources with a VCARD.FN property
        // whose value ends with "Smith"
        System.out.println("Model has " + model.size() + " triples.");
        StmtIterator iter = model.listStatements(
            new SimpleSelector(null, VCARD.FN, (RDFNode) null) {
                    public boolean selects(Statement s) {
                            return s.getString().endsWith("Smith");
                    }
                });
        if (iter.hasNext()) {
            System.out.println("The database contains vcards for:");
            while (iter.hasNext()) {
                System.out.println("  " + iter.nextStatement()
                                              .getString());
            }
        } else {
            System.out.println("No Smith's were found in the database");
        }
        AGJenaUtils.printModel(model);

		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
